/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers;

import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.reader.AuditReaderImpl;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class AuditReaderFactory {
    private AuditReaderFactory() {
    }

    public static AuditReader get(Session session) throws AuditException {
        SessionImplementor sessionImpl = !(session instanceof SessionImplementor) ? (SessionImplementor)session.getSessionFactory().getCurrentSession() : (SessionImplementor)session;
        ServiceRegistryImplementor serviceRegistry = sessionImpl.getFactory().getServiceRegistry();
        EnversService enversService = (EnversService)serviceRegistry.getService(EnversService.class);
        return new AuditReaderImpl(enversService, session, sessionImpl);
    }

    public static AuditReader get(EntityManager entityManager) throws AuditException {
        if (entityManager.getDelegate() instanceof Session) {
            return AuditReaderFactory.get((Session)entityManager.getDelegate());
        }
        if (entityManager.getDelegate() instanceof EntityManager) {
            return AuditReaderFactory.get((EntityManager)entityManager.getDelegate());
        }
        throw new AuditException("Hibernate EntityManager not present!");
    }
}

