/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.inflow.JmsActivation;
import org.jboss.resource.adapter.jms.inflow.JmsActivationSpec;

public class JmsResourceAdapter
implements ResourceAdapter {
    private static final Logger log = Logger.getLogger(JmsResourceAdapter.class);
    private BootstrapContext ctx;
    private ConcurrentHashMap<ActivationSpec, JmsActivation> activations = new ConcurrentHashMap();

    public WorkManager getWorkManager() {
        return this.ctx.getWorkManager();
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        JmsActivation activation = new JmsActivation(this, endpointFactory, (JmsActivationSpec)spec);
        this.activations.put(spec, activation);
        activation.start();
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        JmsActivation activation = this.activations.remove(spec);
        if (activation != null) {
            activation.stop();
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return null;
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        this.ctx = ctx;
    }

    public void stop() {
        Iterator<Map.Entry<ActivationSpec, JmsActivation>> i = this.activations.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<ActivationSpec, JmsActivation> entry = i.next();
            try {
                JmsActivation activation = entry.getValue();
                if (activation != null) {
                    activation.stop();
                }
            }
            catch (Exception ignored) {
                log.debug((Object)"Ignored", (Throwable)ignored);
            }
            i.remove();
        }
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.ctx != null) {
            hashCode += this.ctx.hashCode();
        }
        if (this.activations != null) {
            hashCode += this.activations.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object other) {
        return false;
    }
}

