/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.lang.reflect.AnnotatedElement;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;
import org.hibernate.search.bridge.impl.XMemberToAnnotatedElementAdaptor;
import org.hibernate.search.engine.service.spi.ServiceManager;

class XMemberBridgeProviderContext
implements ExtendedBridgeProvider.ExtendedBridgeProviderContext {
    private final AnnotatedElement annotatedElement;
    private final Class<?> returnTypeElement;
    private final Class<?> returnType;
    private final String memberName;
    private final ServiceManager serviceManager;
    private final boolean isId;
    private final boolean isExplicitlyMarkedAsNumeric;

    public XMemberBridgeProviderContext(XMember member, boolean isId, boolean isExplicitlyMarkedAsNumeric, ReflectionManager reflectionManager, ServiceManager serviceManager) {
        this.annotatedElement = new XMemberToAnnotatedElementAdaptor(member);
        this.returnTypeElement = reflectionManager.toClass(member.getElementClass());
        this.returnType = reflectionManager.toClass(member.getType());
        this.memberName = member.getName();
        this.serviceManager = serviceManager;
        this.isId = isId;
        this.isExplicitlyMarkedAsNumeric = isExplicitlyMarkedAsNumeric;
    }

    @Override
    public Class<?> getReturnType() {
        return this.returnTypeElement;
    }

    @Override
    public Class<?> getElementOrContainerReturnType() {
        return this.returnType;
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    @Override
    public String getMemberName() {
        return this.memberName;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public boolean isId() {
        return this.isId;
    }

    @Override
    public boolean isExplicitlyMarkedAsNumeric() {
        return this.isExplicitlyMarkedAsNumeric;
    }
}

