/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.SecurityFactory;

final class KeyStoreEntrySecurityFactory
implements SecurityFactory<KeyStore.Entry> {
    private final SecurityFactory<KeyStore> keyStore;
    private final String alias;
    private final SecurityFactory<KeyStore.ProtectionParameter> protectionParameter;

    KeyStoreEntrySecurityFactory(KeyStore keyStore, String alias, KeyStore.ProtectionParameter protectionParameter) {
        this((SecurityFactory<KeyStore>)new FixedSecurityFactory((Object)keyStore), alias, (SecurityFactory<KeyStore.ProtectionParameter>)new FixedSecurityFactory((Object)protectionParameter));
    }

    KeyStoreEntrySecurityFactory(SecurityFactory<KeyStore> keyStore, String alias, SecurityFactory<KeyStore.ProtectionParameter> protectionParameter) {
        this.keyStore = keyStore;
        this.alias = alias;
        this.protectionParameter = protectionParameter;
    }

    public KeyStore.Entry create() throws GeneralSecurityException {
        return ((KeyStore)this.keyStore.create()).getEntry(this.alias, this.protectionParameter == null ? null : (KeyStore.ProtectionParameter)this.protectionParameter.create());
    }
}

