/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import org.jboss.as.ee.resource.definition.ResourceDefinitionDescriptorProcessor;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.metadata.javaee.spec.JMSConnectionFactoriesMetaData;
import org.jboss.metadata.javaee.spec.JMSConnectionFactoryMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.wildfly.extension.messaging.activemq.deployment.JMSConnectionFactoryDefinitionInjectionSource;

public class JMSConnectionFactoryDefinitionDescriptorProcessor
extends ResourceDefinitionDescriptorProcessor {
    protected void processEnvironment(RemoteEnvironment environment, ResourceDefinitionDescriptorProcessor.ResourceDefinitionInjectionSources injectionSources) throws DeploymentUnitProcessingException {
        JMSConnectionFactoriesMetaData metaDatas = environment.getJmsConnectionFactories();
        if (metaDatas != null) {
            for (JMSConnectionFactoryMetaData metaData : metaDatas) {
                injectionSources.addResourceDefinitionInjectionSource(this.getResourceDefinitionInjectionSource(metaData));
            }
        }
    }

    private ResourceDefinitionInjectionSource getResourceDefinitionInjectionSource(JMSConnectionFactoryMetaData metadata) {
        JMSConnectionFactoryDefinitionInjectionSource source = new JMSConnectionFactoryDefinitionInjectionSource(metadata.getName());
        source.setInterfaceName(metadata.getInterfaceName());
        source.setClassName(metadata.getClassName());
        source.setResourceAdapter(metadata.getResourceAdapter());
        source.setUser(metadata.getUser());
        source.setPassword(metadata.getPassword());
        source.setClientId(metadata.getClientId());
        source.addProperties(metadata.getProperties());
        source.setTransactional(metadata.isTransactional());
        source.setMaxPoolSize(metadata.getMaxPoolSize());
        source.setMinPoolSize(metadata.getMinPoolSize());
        return source;
    }
}

