/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.constraint.HostEffectConstraint;
import org.jboss.as.domain.management.access.HostScopedRolesResourceDefinition;
import org.jboss.dmr.ModelNode;

class HostScopedRoleWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    private final Map<String, HostEffectConstraint> constraintMap;

    HostScopedRoleWriteAttributeHandler(Map<String, HostEffectConstraint> constraintMap) {
        super(new AttributeDefinition[]{HostScopedRolesResourceDefinition.HOSTS});
        this.constraintMap = constraintMap;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        this.applyChangeToConstraint(operation, resolvedValue);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        this.applyChangeToConstraint(operation, valueToRestore);
    }

    private void applyChangeToConstraint(ModelNode operation, ModelNode resolvedValue) {
        String roleName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        HostEffectConstraint constraint = this.constraintMap.get(roleName);
        assert (constraint != null) : "unknown role " + roleName;
        ArrayList<String> hosts = new ArrayList<String>();
        if (resolvedValue.isDefined()) {
            for (ModelNode host : resolvedValue.asList()) {
                hosts.add(host.asString());
            }
        }
        constraint.setAllowedHosts(hosts);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }
}

