/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;

public class ClusteredCacheServiceConfigurator
extends CacheConfigurationServiceConfigurator {
    private final CacheMode mode;
    private volatile long remoteTimeout;

    ClusteredCacheServiceConfigurator(PathAddress address, CacheMode mode) {
        super(address);
        this.mode = mode.toSync();
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.remoteTimeout = ClusteredCacheResourceDefinition.Attribute.REMOTE_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        return super.configure(context, model);
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        builder.clustering().cacheMode(this.mode).remoteTimeout(this.remoteTimeout, TimeUnit.MILLISECONDS);
        super.accept(builder);
    }
}

