/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.ejb.client.Affinity;

public final class ClusterAffinity
extends Affinity {
    private static final long serialVersionUID = -8078602613739377911L;
    private final String clusterName;

    public ClusterAffinity(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String toString() {
        return String.format("Cluster \"%s\"", this.clusterName);
    }

    @Override
    public URI getUri() {
        try {
            return new URI("cluster", this.clusterName, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ClusterAffinity && this.equals((ClusterAffinity)other);
    }

    @Override
    public boolean equals(Affinity other) {
        return other instanceof ClusterAffinity && this.equals((ClusterAffinity)other);
    }

    public boolean equals(ClusterAffinity other) {
        return other != null && this.clusterName.equals(other.clusterName);
    }

    @Override
    public int hashCode() {
        return this.clusterName.hashCode() + 11;
    }
}

