/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.util;

import java.util.regex.Pattern;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.NameRewriter;

public final class RegexNameValidatingRewriter
implements NameRewriter {
    private final Pattern pattern;
    private final boolean match;

    public RegexNameValidatingRewriter(Pattern pattern, boolean match) {
        this.pattern = (Pattern)Assert.checkNotNullParam((String)"pattern", (Object)pattern);
        this.match = match;
    }

    public String rewriteName(String original) {
        if (original == null) {
            return null;
        }
        return this.pattern.matcher(original).find() != this.match ? null : original;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isMatch() {
        return this.match;
    }
}

