/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import org.jboss.as.clustering.controller.Schema;
import org.jboss.as.clustering.controller.persistence.AttributeXMLBuilderOperator;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentResourceXMLParser;
import org.wildfly.extension.clustering.web.DistributableWebResourceDefinition;
import org.wildfly.extension.clustering.web.DistributableWebSchema;
import org.wildfly.extension.clustering.web.HotRodSSOManagementResourceDefinition;
import org.wildfly.extension.clustering.web.HotRodSessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.InfinispanRoutingProviderResourceDefinition;
import org.wildfly.extension.clustering.web.InfinispanSSOManagementResourceDefinition;
import org.wildfly.extension.clustering.web.InfinispanSessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.LocalAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.LocalRoutingProviderResourceDefinition;
import org.wildfly.extension.clustering.web.NoAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.PrimaryOwnerAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.RankedAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.SessionManagementResourceDefinition;

public class DistributableWebXMLParser
extends PersistentResourceXMLParser {
    private final Schema<DistributableWebSchema> schema;

    public DistributableWebXMLParser(Schema<DistributableWebSchema> schema) {
        this.schema = schema;
    }

    public PersistentResourceXMLDescription getParserDescription() {
        return PersistentResourceXMLDescription.builder((PathElement)DistributableWebResourceDefinition.PATH, (String)this.schema.getNamespaceUri()).addAttribute(DistributableWebResourceDefinition.Attribute.DEFAULT_SESSION_MANAGEMENT.getDefinition()).addAttribute(DistributableWebResourceDefinition.Attribute.DEFAULT_SSO_MANAGEMENT.getDefinition()).addChild(this.getInfinispanSessionManagementResourceXMLBuilder()).addChild(this.getHotRodSessionManagementResourceXMLBuilder()).addChild(new AttributeXMLBuilderOperator(InfinispanSSOManagementResourceDefinition.Attribute.class).apply(PersistentResourceXMLDescription.builder((PathElement)InfinispanSSOManagementResourceDefinition.WILDCARD_PATH))).addChild(new AttributeXMLBuilderOperator(HotRodSSOManagementResourceDefinition.Attribute.class).apply(PersistentResourceXMLDescription.builder((PathElement)HotRodSSOManagementResourceDefinition.WILDCARD_PATH))).addChild(PersistentResourceXMLDescription.builder((PathElement)LocalRoutingProviderResourceDefinition.PATH).setXmlElementName("local-routing")).addChild(new AttributeXMLBuilderOperator(InfinispanRoutingProviderResourceDefinition.Attribute.class).apply(PersistentResourceXMLDescription.builder((PathElement)InfinispanRoutingProviderResourceDefinition.PATH)).setXmlElementName("infinispan-routing")).build();
    }

    private PersistentResourceXMLDescription.PersistentResourceXMLBuilder getInfinispanSessionManagementResourceXMLBuilder() {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = new AttributeXMLBuilderOperator().addAttributes(InfinispanSessionManagementResourceDefinition.Attribute.class).addAttributes(SessionManagementResourceDefinition.Attribute.class).apply(PersistentResourceXMLDescription.builder((PathElement)InfinispanSessionManagementResourceDefinition.WILDCARD_PATH));
        this.addAffinityChildren(builder).addChild(PersistentResourceXMLDescription.builder((PathElement)PrimaryOwnerAffinityResourceDefinition.PATH).setXmlElementName("primary-owner-affinity"));
        if (this.schema.since((Schema)DistributableWebSchema.VERSION_2_0)) {
            builder.addChild(new AttributeXMLBuilderOperator(RankedAffinityResourceDefinition.Attribute.class).apply(PersistentResourceXMLDescription.builder((PathElement)RankedAffinityResourceDefinition.PATH).setXmlElementName("ranked-affinity")));
        }
        return builder;
    }

    private PersistentResourceXMLDescription.PersistentResourceXMLBuilder getHotRodSessionManagementResourceXMLBuilder() {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = new AttributeXMLBuilderOperator().addAttributes(HotRodSessionManagementResourceDefinition.Attribute.class).addAttributes(SessionManagementResourceDefinition.Attribute.class).apply(PersistentResourceXMLDescription.builder((PathElement)HotRodSessionManagementResourceDefinition.WILDCARD_PATH));
        return this.addAffinityChildren(builder);
    }

    private PersistentResourceXMLDescription.PersistentResourceXMLBuilder addAffinityChildren(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        return builder.addChild(PersistentResourceXMLDescription.builder((PathElement)NoAffinityResourceDefinition.PATH).setXmlElementName("no-affinity")).addChild(PersistentResourceXMLDescription.builder((PathElement)LocalAffinityResourceDefinition.PATH).setXmlElementName("local-affinity"));
    }
}

