/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.uni.builders.UniJoinAll;
import io.smallrye.mutiny.operators.uni.builders.UniJoinFirst;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Experimental(value="New API based on observations that Uni.combine() is often used with homogeneous types, and combination often just a mapping to a collection.")
public class UniJoin {
    public static final UniJoin SHARED_INSTANCE = new UniJoin();

    private UniJoin() {
    }

    @SafeVarargs
    public final <T> JoinAllStrategy<T> all(Uni<? extends T> ... unis) {
        return this.all(Arrays.asList(ParameterValidation.nonNull(unis, "unis")));
    }

    public final <T> JoinAllStrategy<T> all(List<Uni<? extends T>> unis) {
        return new JoinAllStrategy(ParameterValidation.doesNotContainNull(unis, "unis"));
    }

    @SafeVarargs
    public final <T> JoinFirstStrategy<T> first(Uni<? extends T> ... unis) {
        return this.first(Arrays.asList(ParameterValidation.nonNull(unis, "unis")));
    }

    public final <T> JoinFirstStrategy<T> first(List<Uni<? extends T>> unis) {
        return new JoinFirstStrategy(ParameterValidation.doesNotContainNull(unis, "unis"));
    }

    public <T> Builder<T> builder() {
        return new Builder();
    }

    public class Builder<T> {
        private final List<Uni<? extends T>> unis = new ArrayList<Uni<? extends T>>();

        public Builder<T> add(Uni<? extends T> uni) {
            this.unis.add(uni);
            return this;
        }

        public JoinAllStrategy<T> joinAll() {
            return UniJoin.this.all(this.unis);
        }

        public JoinFirstStrategy<T> joinFirst() {
            return UniJoin.this.first(this.unis);
        }
    }

    public static class JoinFirstStrategy<T> {
        private final List<Uni<? extends T>> unis;

        private JoinFirstStrategy(List<Uni<? extends T>> unis) {
            this.unis = unis;
        }

        public Uni<T> toTerminate() {
            return Infrastructure.onUniCreation(new UniJoinFirst<T>(this.unis, UniJoinFirst.Mode.FIRST_TO_EMIT));
        }

        public Uni<T> withItem() {
            return Infrastructure.onUniCreation(new UniJoinFirst<T>(this.unis, UniJoinFirst.Mode.FIRST_WITH_ITEM));
        }
    }

    public static class JoinAllStrategy<T> {
        private final List<Uni<? extends T>> unis;

        private JoinAllStrategy(List<Uni<? extends T>> unis) {
            this.unis = unis;
        }

        public Uni<List<T>> andCollectFailures() {
            return Infrastructure.onUniCreation(new UniJoinAll<T>(this.unis, UniJoinAll.Mode.COLLECT_FAILURES));
        }

        public Uni<List<T>> andFailFast() {
            return Infrastructure.onUniCreation(new UniJoinAll<T>(this.unis, UniJoinAll.Mode.FAIL_FAST));
        }
    }
}

