/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.io.IOException;
import java.time.Instant;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.ejb.client.SessionID;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanEntry;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class InfinispanBeanEntryMarshaller
implements ProtoStreamMarshaller<InfinispanBeanEntry<SessionID>> {
    private static final int BEAN_NAME_INDEX = 1;
    private static final int GROUP_INDEX = 2;
    private static final int LAST_ACCESSED_INDEX = 3;

    public InfinispanBeanEntry<SessionID> readFrom(ProtoStreamReader reader) throws IOException {
        String beanName = null;
        SessionID groupId = null;
        Instant lastAccessed = null;
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    beanName = reader.readString();
                    continue block5;
                }
                case 2: {
                    groupId = (SessionID)reader.readObject(SessionID.class);
                    continue block5;
                }
                case 3: {
                    lastAccessed = (Instant)reader.readObject(Instant.class);
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        InfinispanBeanEntry<Object> entry = new InfinispanBeanEntry<Object>(beanName, groupId);
        entry.setLastAccessedTime(lastAccessed);
        return entry;
    }

    public void writeTo(ProtoStreamWriter writer, InfinispanBeanEntry<SessionID> entry) throws IOException {
        writer.writeString(1, entry.getBeanName());
        writer.writeObject(2, (Object)entry.getGroupId());
        Instant lastAccessed = entry.getLastAccessedTime();
        if (lastAccessed != null) {
            writer.writeObject(3, (Object)lastAccessed);
        }
    }

    public Class<? extends InfinispanBeanEntry<SessionID>> getJavaClass() {
        return InfinispanBeanEntry.class;
    }
}

