/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.impl.lucene.analysis.ConcurrentlyMutableAnalyzer;
import org.hibernate.search.backend.impl.lucene.overrides.ConcurrentMergeScheduler;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class IndexWriterHolder {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final ErrorHandler errorHandler;
    private final LuceneIndexingParameters.ParameterSet indexParameters;
    private final DirectoryProvider directoryProvider;
    private final IndexManager indexManager;
    private final String indexName;
    private final AtomicReference<IndexWriter> writer = new AtomicReference();
    private final ReentrantLock writerInitializationLock = new ReentrantLock();
    private final Similarity similarity;
    private final LuceneIndexingParameters luceneParameters;

    IndexWriterHolder(ErrorHandler errorHandler, DirectoryBasedIndexManager indexManager) {
        this.errorHandler = errorHandler;
        this.indexManager = indexManager;
        this.indexName = indexManager.getIndexName();
        this.luceneParameters = indexManager.getIndexingParameters();
        this.indexParameters = this.luceneParameters.getIndexParameters();
        this.directoryProvider = indexManager.getDirectoryProvider();
        this.similarity = indexManager.getSimilarity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter getIndexWriter(ErrorContextBuilder errorContextBuilder) {
        IndexWriter indexWriter = this.writer.get();
        if (indexWriter == null) {
            this.writerInitializationLock.lock();
            try {
                indexWriter = this.writer.get();
                if (indexWriter == null) {
                    try {
                        indexWriter = this.createNewIndexWriter();
                        log.trace("IndexWriter opened");
                        this.writer.set(indexWriter);
                    }
                    catch (IOException ioe) {
                        indexWriter = null;
                        this.writer.set(null);
                        this.handleIOException(ioe, errorContextBuilder);
                    }
                }
            }
            finally {
                this.writerInitializationLock.unlock();
            }
        }
        return indexWriter;
    }

    public IndexWriter getIndexWriter() {
        return this.getIndexWriter(null);
    }

    private IndexWriter createNewIndexWriter() throws IOException {
        IndexWriterConfig indexWriterConfig = this.createWriterConfig();
        LogByteSizeMergePolicy newMergePolicy = this.indexParameters.getNewMergePolicy();
        indexWriterConfig.setMergePolicy((MergePolicy)newMergePolicy);
        ConcurrentMergeScheduler mergeScheduler = new ConcurrentMergeScheduler(this.errorHandler, this.indexName);
        indexWriterConfig.setMergeScheduler((MergeScheduler)mergeScheduler);
        return new IndexWriter(this.directoryProvider.getDirectory(), indexWriterConfig);
    }

    private IndexWriterConfig createWriterConfig() {
        ConcurrentlyMutableAnalyzer globalAnalyzer = new ConcurrentlyMutableAnalyzer((Analyzer)new SimpleAnalyzer());
        IndexWriterConfig writerConfig = new IndexWriterConfig((Analyzer)globalAnalyzer);
        this.luceneParameters.applyToWriter(writerConfig);
        if (this.similarity != null) {
            writerConfig.setSimilarity(this.similarity);
        }
        writerConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        return writerConfig;
    }

    public void commitIndexWriter(ErrorContextBuilder errorContextBuilder) {
        IndexWriter indexWriter = this.writer.get();
        if (indexWriter != null) {
            try {
                indexWriter.commit();
                log.trace("Index changes committed.");
            }
            catch (IOException ioe) {
                this.handleIOException(ioe, errorContextBuilder);
            }
        }
    }

    public void commitIndexWriter() {
        this.commitIndexWriter(null);
    }

    public void closeIndexWriter() {
        IndexWriter toClose = this.writer.getAndSet(null);
        if (toClose != null) {
            try {
                toClose.close();
                log.trace("IndexWriter closed");
            }
            catch (IOException ioe) {
                this.forceLockRelease();
                this.handleIOException(ioe, null);
            }
        }
    }

    public void forceLockRelease() {
        log.forcingReleaseIndexWriterLock();
        this.writerInitializationLock.lock();
        try {
            IndexWriter indexWriter = this.writer.getAndSet(null);
            if (indexWriter != null) {
                indexWriter.close();
                log.trace("IndexWriter closed");
            }
        }
        catch (IOException ioe) {
            this.handleIOException(ioe, null);
        }
        finally {
            this.writerInitializationLock.unlock();
        }
    }

    public DirectoryReader openNRTIndexReader(boolean applyDeletes) {
        IndexWriter indexWriter = this.writer.get();
        try {
            if (indexWriter != null) {
                return DirectoryReader.open((IndexWriter)indexWriter, (boolean)applyDeletes);
            }
            return null;
        }
        catch (CorruptIndexException cie) {
            throw log.cantOpenCorruptedIndex(cie, this.indexName);
        }
        catch (IOException ioe) {
            throw log.ioExceptionOnIndex(ioe, this.indexName);
        }
    }

    public DirectoryReader openDirectoryIndexReader() {
        try {
            return DirectoryReader.open(this.directoryProvider.getDirectory());
        }
        catch (CorruptIndexException cie) {
            throw log.cantOpenCorruptedIndex(cie, this.indexName);
        }
        catch (IOException ioe) {
            throw log.ioExceptionOnIndex(ioe, this.indexName);
        }
    }

    private void handleIOException(IOException ioe, ErrorContextBuilder errorContextBuilder) {
        if (log.isTraceEnabled()) {
            log.trace("going to handle IOException", ioe);
        }
        if (errorContextBuilder != null) {
            ErrorContext errorContext = errorContextBuilder.errorThatOccurred(ioe).indexManager(this.indexManager).createErrorContext();
            this.errorHandler.handle(errorContext);
        } else {
            this.errorHandler.handleException(log.ioExceptionOnIndexWriter(), ioe);
        }
    }
}

