/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.ConsumerThread;
import org.apache.activemq.artemis.cli.commands.messages.DestAbstract;
import org.apache.activemq.artemis.cli.factory.serialize.MessageSerializer;

@Command(name="consumer", description="It will consume messages from an instance")
public class Consumer
extends DestAbstract {
    @Option(name={"--durable"}, description="It will use durable subscription in case of client")
    boolean durable = false;
    @Option(name={"--break-on-null"}, description="It will break on null messages")
    boolean breakOnNull = false;
    @Option(name={"--receive-timeout"}, description="Time used on receive(timeout)")
    int receiveTimeout = 3000;
    @Option(name={"--filter"}, description="filter to be used with the consumer")
    String filter;
    @Option(name={"--data"}, description="serialize the messages to the specified file as they are consumed")
    String file;

    /*
     * WARNING - void declaration
     */
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        System.out.println("Consumer:: filter = " + this.filter);
        SerialiserMessageListener listener = null;
        MessageSerializer serializer = null;
        if (this.file != null) {
            FileOutputStream out;
            serializer = this.getMessageSerializer();
            if (serializer == null) {
                System.err.println("Error. Unable to instantiate serializer class: " + this.serializer);
                return null;
            }
            try {
                out = new FileOutputStream(this.file);
            }
            catch (Exception e) {
                System.err.println("Error: Unable to open file for writing\n" + e.getMessage());
                return null;
            }
            listener = new SerialiserMessageListener(serializer, out);
            serializer.start();
        }
        ConnectionFactory factory = this.createConnectionFactory();
        try (Connection connection = factory.createConnection();){
            ConsumerThread[] threadsArray = new ConsumerThread[this.threads];
            for (int i = 0; i < this.threads; ++i) {
                void var9_13;
                if (this.txBatchSize > 0) {
                    Session session = connection.createSession(true, 0);
                } else {
                    Session object = connection.createSession(false, 1);
                }
                Destination dest = this.getDestination((Session)var9_13);
                threadsArray[i] = new ConsumerThread((Session)var9_13, dest, i);
                threadsArray[i].setVerbose(this.verbose).setSleep(this.sleep).setDurable(this.durable).setBatchSize(this.txBatchSize).setBreakOnNull(this.breakOnNull).setMessageCount(this.messageCount).setReceiveTimeOut(this.receiveTimeout).setFilter(this.filter).setBrowse(false).setListener(listener);
            }
            for (ConsumerThread thread : threadsArray) {
                thread.start();
            }
            connection.start();
            int received = 0;
            for (ConsumerThread thread : threadsArray) {
                thread.join();
                received += thread.getReceived();
            }
            if (serializer != null) {
                serializer.stop();
            }
            Integer n = received;
            return n;
        }
    }

    public boolean isDurable() {
        return this.durable;
    }

    public Consumer setDurable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public boolean isBreakOnNull() {
        return this.breakOnNull;
    }

    public Consumer setBreakOnNull(boolean breakOnNull) {
        this.breakOnNull = breakOnNull;
        return this;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public Consumer setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public Consumer setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getFile() {
        return this.file;
    }

    public Consumer setFile(String file) {
        this.file = file;
        return this;
    }

    private class SerialiserMessageListener
    implements MessageListener {
        private MessageSerializer messageSerializer;

        SerialiserMessageListener(MessageSerializer messageSerializer, OutputStream outputStream) throws Exception {
            this.messageSerializer = messageSerializer;
            this.messageSerializer.setOutput(outputStream);
        }

        public void onMessage(Message message) {
            this.messageSerializer.write(message);
        }
    }
}

