/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.util.MdbValidityStatus;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;

public final class EjbValidationsUtil {
    private EjbValidationsUtil() {
    }

    public static Collection<MdbValidityStatus> assertEjbClassValidity(ClassInfo mdbClass) throws DeploymentUnitProcessingException {
        ArrayList<MdbValidityStatus> mdbComplianceIssueList = new ArrayList<MdbValidityStatus>(MdbValidityStatus.values().length);
        String className = mdbClass.name().toString();
        EjbValidationsUtil.verifyModifiers(className, mdbClass.flags(), mdbComplianceIssueList);
        for (MethodInfo method : mdbClass.methods()) {
            if ("onMessage".equals(method.name())) {
                EjbValidationsUtil.verifyOnMessageMethod(className, method.flags(), mdbComplianceIssueList);
            }
            if (!"finalize".equals(method.name())) continue;
            EjbLogger.DEPLOYMENT_LOGGER.mdbCantHaveFinalizeMethod(className);
            mdbComplianceIssueList.add(MdbValidityStatus.MDB_SHOULD_NOT_HAVE_FINALIZE_METHOD);
        }
        return mdbComplianceIssueList;
    }

    private static void verifyModifiers(String className, short flags, Collection<MdbValidityStatus> mdbComplianceIssueList) {
        if (Modifier.isInterface(flags)) {
            EjbLogger.DEPLOYMENT_LOGGER.mdbClassCannotBeAnInterface(className);
            mdbComplianceIssueList.add(MdbValidityStatus.MDB_CANNOT_BE_AN_INTERFACE);
        }
        if (!Modifier.isPublic(flags) || Modifier.isAbstract(flags) || Modifier.isFinal(flags)) {
            EjbLogger.DEPLOYMENT_LOGGER.mdbClassMustBePublicNonAbstractNonFinal(className);
            mdbComplianceIssueList.add(MdbValidityStatus.MDB_CLASS_CANNOT_BE_PRIVATE_ABSTRACT_OR_FINAL);
        }
    }

    private static void verifyOnMessageMethod(String className, short methodsFlags, Collection<MdbValidityStatus> mdbComplianceIssueList) {
        if (Modifier.isFinal(methodsFlags)) {
            EjbLogger.DEPLOYMENT_LOGGER.mdbOnMessageMethodCantBeFinal(className);
            mdbComplianceIssueList.add(MdbValidityStatus.MDB_ON_MESSAGE_METHOD_CANT_BE_FINAL);
        }
        if (Modifier.isStatic(methodsFlags)) {
            EjbLogger.DEPLOYMENT_LOGGER.mdbOnMessageMethodCantBeStatic(className);
            mdbComplianceIssueList.add(MdbValidityStatus.MDB_ON_MESSAGE_METHOD_CANT_BE_STATIC);
        }
        if (Modifier.isPrivate(methodsFlags)) {
            EjbLogger.DEPLOYMENT_LOGGER.mdbOnMessageMethodCantBePrivate(className);
            mdbComplianceIssueList.add(MdbValidityStatus.MDB_ON_MESSAGE_METHOD_CANT_BE_PRIVATE);
        }
    }

    public static void verifyEjbClassAndDefaultConstructor(Constructor<?> ctor, Class<?> enclosingClass, boolean noInterface, String componentName, String componentClassname, int modifiers) throws DeploymentUnitProcessingException {
        if (ctor == null && noInterface) {
            throw EjbLogger.ROOT_LOGGER.ejbMustHavePublicDefaultConstructor(componentName, componentClassname);
        }
        if (enclosingClass != null) {
            throw EjbLogger.ROOT_LOGGER.ejbMustNotBeInnerClass(componentName, componentClassname);
        }
        if (!Modifier.isPublic(modifiers)) {
            throw EjbLogger.ROOT_LOGGER.ejbMustBePublicClass(componentName, componentClassname);
        }
        if (Modifier.isFinal(modifiers)) {
            throw EjbLogger.ROOT_LOGGER.ejbMustNotBeFinalClass(componentName, componentClassname);
        }
    }

    public static boolean verifyEjbPublicMethodAreNotFinalNorStatic(Method[] methods, String classname) {
        boolean isEjbCompliant = true;
        for (Method method : methods) {
            if (!Modifier.isPublic(method.getModifiers()) || EjbValidationsUtil.verifyMethodIsNotFinalNorStatic(method, classname)) continue;
            isEjbCompliant = false;
        }
        return isEjbCompliant;
    }

    public static boolean verifyMethodIsNotFinalNorStatic(Method method, String classname) {
        boolean isMethodCompliant = true;
        if (Modifier.isStatic(method.getModifiers()) || Modifier.isFinal(method.getModifiers())) {
            EjbLogger.ROOT_LOGGER.ejbMethodMustNotBeFinalNorStatic(classname, method.getName());
            isMethodCompliant = false;
        }
        return isMethodCompliant;
    }

    public static List<Method> getBusinessMethods(Class<?> componentClass) {
        Map<String, List<Method>> interfacesMethodIndexedByName;
        Method[] componentDeclaredMethods = componentClass.getDeclaredMethods();
        ArrayList<Method> businessMethodList = new ArrayList<Method>(componentDeclaredMethods.length);
        if (componentDeclaredMethods.length > 0 && !(interfacesMethodIndexedByName = EjbValidationsUtil.indexAllMethodsFromInterfaces(componentClass.getInterfaces())).isEmpty()) {
            for (Method method : componentClass.getDeclaredMethods()) {
                if (!interfacesMethodIndexedByName.containsKey(method.getName())) continue;
                EjbValidationsUtil.addMethodIfMatchesAnInterfaceMethod(interfacesMethodIndexedByName.get(method.getName()), businessMethodList, method);
            }
        }
        return businessMethodList;
    }

    private static void addMethodIfMatchesAnInterfaceMethod(List<Method> businessMethods, List<Method> businessMethodList, Method method) {
        for (Method biznessMethod : businessMethods) {
            if (!EjbValidationsUtil.hasSameSignature(biznessMethod, method)) continue;
            businessMethodList.add(method);
        }
    }

    private static boolean hasSameSignature(Method left, Method right) {
        return left.getName().equals(right.getName()) && left.getReturnType().equals(right.getReturnType()) && left.getParameterCount() == right.getParameterCount() && Arrays.equals(left.getParameters(), right.getParameters());
    }

    private static Map<String, List<Method>> indexAllMethodsFromInterfaces(Class<?>[] classes) {
        HashMap<String, List<Method>> businessMethods = new HashMap<String, List<Method>>();
        for (Class<?> clazz : classes) {
            for (Method m : clazz.getDeclaredMethods()) {
                EjbValidationsUtil.addMethodToListIfMatchesInterfacesMethod(m, businessMethods);
            }
        }
        return businessMethods;
    }

    private static void addMethodToListIfMatchesInterfacesMethod(Method m, Map<String, List<Method>> map) {
        if (map.containsKey(m.getName())) {
            map.get(m.getName()).add(m);
        } else {
            ArrayList<Method> methods = new ArrayList<Method>(1);
            methods.add(m);
            map.put(m.getName(), methods);
        }
    }
}

