/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.baggage;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.api.baggage.ImmutableEntry;
import io.opentelemetry.api.internal.ImmutableKeyValuePairs;
import io.opentelemetry.api.internal.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ImmutableBaggage
extends ImmutableKeyValuePairs<String, BaggageEntry>
implements Baggage {
    private static final Baggage EMPTY = new Builder().build();

    private ImmutableBaggage(Object[] data) {
        super(data, Comparator.naturalOrder());
    }

    static Baggage empty() {
        return EMPTY;
    }

    static BaggageBuilder builder() {
        return new Builder();
    }

    @Override
    @Nullable
    public String getEntryValue(String entryKey) {
        BaggageEntry entry = (BaggageEntry)this.get(entryKey);
        return entry != null ? entry.getValue() : null;
    }

    @Override
    public BaggageBuilder toBuilder() {
        return new Builder(new ArrayList<Object>(this.data()));
    }

    private static Baggage sortAndFilterToBaggage(Object[] data) {
        return new ImmutableBaggage(data);
    }

    private static boolean isKeyValid(String name) {
        return name != null && !name.isEmpty() && StringUtils.isPrintableString(name);
    }

    private static boolean isValueValid(String value) {
        return value != null;
    }

    static class Builder
    implements BaggageBuilder {
        private final List<Object> data;

        Builder() {
            this.data = new ArrayList<Object>();
        }

        Builder(List<Object> data) {
            this.data = data;
        }

        @Override
        public BaggageBuilder put(String key, String value, BaggageEntryMetadata entryMetadata) {
            if (!ImmutableBaggage.isKeyValid(key) || !ImmutableBaggage.isValueValid(value) || entryMetadata == null) {
                return this;
            }
            this.data.add(key);
            this.data.add(ImmutableEntry.create(value, entryMetadata));
            return this;
        }

        @Override
        public BaggageBuilder remove(String key) {
            if (key == null) {
                return this;
            }
            this.data.add(key);
            this.data.add(null);
            return this;
        }

        @Override
        public Baggage build() {
            return ImmutableBaggage.sortAndFilterToBaggage(this.data.toArray());
        }
    }
}

