/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.converters;

import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordBatchMetadata;
import java.lang.reflect.Type;
import javax.enterprise.context.ApplicationScoped;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class ConsumerRecordsConverter
implements MessageConverter {
    public boolean canConvert(Message<?> in, Type target) {
        return in.getMetadata(IncomingKafkaRecordBatchMetadata.class).isPresent() && target.equals(ConsumerRecords.class);
    }

    public Message<?> convert(Message<?> in, Type target) {
        IncomingKafkaRecordBatchMetadata metadata = (IncomingKafkaRecordBatchMetadata)in.getMetadata(IncomingKafkaRecordBatchMetadata.class).orElseThrow(() -> new IllegalStateException("No Kafka metadata"));
        return in.withPayload((Object)metadata.getRecords());
    }
}

