/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiBroadcaster;
import java.time.Duration;

public class MultiBroadcast<T> {
    private final Multi<T> upstream;
    private boolean cancelWhenNoOneIsListening;
    private Duration delayAfterLastDeparture;

    public MultiBroadcast(Multi<T> upstream) {
        this.upstream = upstream;
    }

    public Multi<T> toAllSubscribers() {
        return Infrastructure.onMultiCreation(MultiBroadcaster.publish(this.upstream, 0, this.cancelWhenNoOneIsListening, this.delayAfterLastDeparture));
    }

    public Multi<T> toAtLeast(int numberOfSubscribers) {
        ParameterValidation.positive(numberOfSubscribers, "numberOfSubscribers");
        return Infrastructure.onMultiCreation(MultiBroadcaster.publish(this.upstream, numberOfSubscribers, this.cancelWhenNoOneIsListening, this.delayAfterLastDeparture));
    }

    public MultiBroadcast<T> withCancellationAfterLastSubscriberDeparture() {
        this.cancelWhenNoOneIsListening = true;
        return this;
    }

    public MultiBroadcast<T> withCancellationAfterLastSubscriberDeparture(Duration delay) {
        this.delayAfterLastDeparture = ParameterValidation.validate(delay, "delay");
        this.withCancellationAfterLastSubscriberDeparture();
        return this;
    }
}

