/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.search.backend.impl.lucene.AbstractCommitPolicy;
import org.hibernate.search.backend.impl.lucene.IndexWriterHolder;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ScheduledCommitPolicy
extends AbstractCommitPolicy {
    public static final int DEFAULT_DELAY_MS = 1000;
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private volatile ScheduledExecutorService scheduledExecutorService;
    private final ErrorHandler errorHandler;
    private final int delay;
    private final String indexName;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public ScheduledCommitPolicy(IndexWriterHolder indexWriterHolder, String indexName, int delay, ErrorHandler errorHandler) {
        super(indexWriterHolder);
        this.indexName = indexName;
        this.delay = delay;
        this.errorHandler = errorHandler;
    }

    public int getDelay() {
        return this.delay;
    }

    @Override
    public void onChangeSetApplied(boolean someFailureHappened, boolean streaming) {
        if (!this.running.get()) {
            this.startScheduledExecutor();
        }
        if (someFailureHappened) {
            this.indexWriterHolder.forceLockRelease();
        }
    }

    public synchronized ScheduledExecutorService getScheduledExecutorService() {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool("Commit Scheduler for index " + this.indexName);
        }
        return this.scheduledExecutorService;
    }

    @Override
    public void onFlush() {
        this.indexWriterHolder.commitIndexWriter();
    }

    @Override
    public void onClose() {
        if (this.scheduledExecutorService != null) {
            this.stopScheduledExecutor();
        }
    }

    private synchronized void stopScheduledExecutor() {
        if (this.scheduledExecutorService == null) {
            return;
        }
        try {
            this.scheduledExecutorService.shutdown();
            this.scheduledExecutorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            this.running.set(false);
            this.scheduledExecutorService = null;
        }
        catch (InterruptedException e) {
            log.timedOutWaitingShutdown(this.indexName);
        }
    }

    private synchronized void startScheduledExecutor() {
        if (this.running.get()) {
            return;
        }
        this.getScheduledExecutorService().scheduleWithFixedDelay(new CommitTask(), this.delay, this.delay, TimeUnit.MILLISECONDS);
        this.running.set(true);
    }

    private final class CommitTask
    implements Runnable {
        private CommitTask() {
        }

        @Override
        public void run() {
            try {
                ScheduledCommitPolicy.this.indexWriterHolder.commitIndexWriter();
            }
            catch (Exception e) {
                ScheduledCommitPolicy.this.errorHandler.handleException("Error caught in background thread of ScheduledCommitPolicy", e);
            }
        }
    }
}

