/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;

public class RAW
extends Datum {
    static final long serialVersionUID = -3298750557928937840L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    static int hexDigit2Nibble(char c2) throws SQLException {
        int n2 = Character.digit(c2, 16);
        if (n2 == -1) {
            SQLException sQLException = DatabaseError.createSqlException(null, 59, "Invalid hex digit: " + c2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return n2;
    }

    public static byte[] hexString2Bytes(String string) throws SQLException {
        byte[] byArray;
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        int n3 = 0;
        int n4 = 0;
        if (n2 == 0) {
            return new byte[0];
        }
        if (n2 % 2 > 0) {
            byArray = new byte[(n2 + 1) / 2];
            byArray[n3++] = (byte)RAW.hexDigit2Nibble(cArray[n4++]);
        } else {
            byArray = new byte[n2 / 2];
        }
        while (n3 < byArray.length) {
            byArray[n3] = (byte)(RAW.hexDigit2Nibble(cArray[n4++]) << 4 | RAW.hexDigit2Nibble(cArray[n4++]));
            ++n3;
        }
        return byArray;
    }

    public static RAW newRAW(Object object) throws SQLException {
        RAW rAW = new RAW(object);
        return rAW;
    }

    public static RAW oldRAW(Object object) throws SQLException {
        RAW rAW;
        if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = null;
            try {
                byArray = string.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                SQLException sQLException = DatabaseError.createSqlException(null, 109, "ISO8859_1 character encoding not found");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            rAW = new RAW(byArray);
        } else {
            rAW = new RAW(object);
        }
        return rAW;
    }

    public RAW() {
    }

    public RAW(byte[] byArray) {
        super(byArray);
    }

    public RAW(Object object) throws SQLException {
        this();
        if (object instanceof byte[]) {
            this.setShareBytes((byte[])object);
        } else if (object instanceof String) {
            this.setShareBytes(RAW.hexString2Bytes((String)object));
        } else {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this.getBytes();
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    @Override
    public String stringValue() {
        String string = RepConversion.bArray2String(this.getBytes());
        return string;
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        int n2 = (int)this.getLength();
        char[] cArray = new char[n2 * 2];
        byte[] byArray = this.shareBytes();
        DBConversion.RAWBytesToHexChars(byArray, n2, cArray);
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        return charArrayReader;
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        int n2 = (int)this.getLength();
        char[] cArray = new char[n2 * 2];
        byte[] byArray = this.shareBytes();
        DBConversion.RAWBytesToHexChars(byArray, n2, cArray);
        byte[] byArray2 = new byte[n2 * 2];
        DBConversion.javaCharsToAsciiBytes(cArray, n2 * 2, byArray2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        return byteArrayInputStream;
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.getStream();
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new byte[n2][];
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

