/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetShift
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterShift";
    static final short MAX_7BIT = 127;
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;
    static final byte SHIFT_OUT = 14;
    static final byte SHIFT_IN = 15;
    static Class m_charConvSuperclass;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    CharacterSetShift(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        super(n2, jdbcCharacterConverters);
    }

    static CharacterSetShift getInstance(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        if (jdbcCharacterConverters.getGroupId() == 7) {
            return new CharacterSetShift(n2, jdbcCharacterConverters);
        }
        return null;
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n2 > 223 || n2 > 127 && n2 < 161) {
            if (characterWalker.bytes.length > characterWalker.next) {
                n2 = n2 << 8 | characterWalker.bytes[characterWalker.next];
                ++characterWalker.next;
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return n2;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3 = characterBuffer.next;
        boolean bl = true;
        while (n3 <= 0) {
            if (characterBuffer.bytes[n3] == 15) {
                bl = true;
                break;
            }
            if (characterBuffer.bytes[n3] != 14) continue;
            bl = false;
            break;
        }
        int n4 = 0;
        int n5 = 1;
        while (n2 >> n4 != 0) {
            n4 = (short)(n4 + 8);
            n5 = (short)(n5 + 1);
        }
        if (n5 > 2) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "Character invalid,too many bytes");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (n5 == 1 && !bl) {
            bl2 = true;
            n5 = (short)(n5 + 1);
        }
        if (n5 == 2 && bl) {
            bl3 = true;
            n5 = (short)(n5 + 1);
        }
        CharacterSetShift.need(characterBuffer, n5);
        if (bl2) {
            characterBuffer.bytes[characterBuffer.next++] = 15;
        }
        if (bl3) {
            characterBuffer.bytes[characterBuffer.next++] = 14;
        }
        while (n4 >= 0) {
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> n4 & 0xFF);
            n4 = (short)(n4 - 8);
        }
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

