/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Objects;
import org.wildfly.common.Assert;

public final class RuntimePackageDependency {
    private final String name;
    private final TYPE type;

    private RuntimePackageDependency(String name, TYPE type) {
        this.name = (String)Assert.checkNotNullParamWithNullPointerException((String)"name", (Object)name);
        this.type = (TYPE)((Object)Assert.checkNotNullParamWithNullPointerException((String)"type", (Object)((Object)type)));
    }

    public String getName() {
        return this.name;
    }

    public boolean isOptional() {
        return this.type == TYPE.OPTIONAL || this.type == TYPE.PASSIVE;
    }

    public boolean isRequired() {
        return this.type == TYPE.REQUIRED;
    }

    public boolean isPassive() {
        return this.type == TYPE.PASSIVE;
    }

    public static RuntimePackageDependency passive(String name) {
        return new RuntimePackageDependency(name, TYPE.PASSIVE);
    }

    public static RuntimePackageDependency required(String name) {
        return new RuntimePackageDependency(name, TYPE.REQUIRED);
    }

    public static RuntimePackageDependency optional(String name) {
        return new RuntimePackageDependency(name, TYPE.OPTIONAL);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.name);
        hash = 71 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuntimePackageDependency other = (RuntimePackageDependency)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "RuntimePackageDependency{name=" + this.name + ", type=" + (Object)((Object)this.type) + '}';
    }

    private static enum TYPE {
        REQUIRED,
        OPTIONAL,
        PASSIVE;

    }
}

