/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.fault;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.kafka.SerializationFailureHandler;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;

public class SerializerWrapper<T>
implements Serializer<T> {
    private final Serializer<T> delegate;
    private final boolean handleKeys;
    private final SerializationFailureHandler<T> serializationFailureHandler;

    public SerializerWrapper(String className, boolean handleKeys, SerializationFailureHandler<T> failureHandler) {
        this.delegate = this.createDelegateSerializer(className);
        this.handleKeys = handleKeys;
        this.serializationFailureHandler = failureHandler;
    }

    private Serializer<T> createDelegateSerializer(String clazz) {
        try {
            return (Serializer)Utils.newInstance((String)clazz, Serializer.class);
        }
        catch (ClassNotFoundException e) {
            throw KafkaExceptions.ex.unableToCreateInstance(clazz, e);
        }
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        try {
            this.delegate.configure(configs, isKey);
        }
        catch (Exception e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public byte[] serialize(String topic, T data) {
        return this.wrapSerialize(() -> this.delegate.serialize(topic, data), topic, null, data);
    }

    public byte[] serialize(String topic, Headers headers, T data) {
        return this.wrapSerialize(() -> this.delegate.serialize(topic, headers, data), topic, headers, data);
    }

    private byte[] wrapSerialize(Supplier<byte[]> serialize, String topic, Headers headers, T data) {
        if (this.serializationFailureHandler != null) {
            try {
                return this.serializationFailureHandler.decorateSerialization((Uni<byte[]>)Uni.createFrom().item(serialize), topic, this.handleKeys, this.delegate.getClass().getName(), data, headers);
            }
            catch (Exception e) {
                KafkaLogging.log.deserializationFailureHandlerFailure(this.serializationFailureHandler.toString(), e);
                throw e;
            }
        }
        try {
            return serialize.get();
        }
        catch (Exception e) {
            KafkaLogging.log.unableToSerializeMessage(topic, e);
            throw e;
        }
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

