/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger;

import com.fasterxml.jackson.jr.ob.JSON;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.jaeger.proto.api_v2.internal.KeyValue;
import io.opentelemetry.exporter.jaeger.proto.api_v2.internal.ValueType;
import io.opentelemetry.exporter.otlp.internal.MarshalerUtil;
import io.opentelemetry.exporter.otlp.internal.MarshalerWithSize;
import io.opentelemetry.exporter.otlp.internal.ProtoEnumInfo;
import io.opentelemetry.exporter.otlp.internal.ProtoFieldInfo;
import io.opentelemetry.exporter.otlp.internal.Serializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class KeyValueMarshaler
extends MarshalerWithSize {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final byte[] keyUtf8;
    private final ProtoEnumInfo valueType;
    private final byte[] vStrUtf8;
    private final boolean vBool;
    private final long vInt64;
    private final double vFloat64;

    static List<KeyValueMarshaler> createRepeated(Attributes attributes) {
        if (attributes.isEmpty()) {
            return new ArrayList<KeyValueMarshaler>();
        }
        ArrayList<KeyValueMarshaler> marshalers = new ArrayList<KeyValueMarshaler>(attributes.size());
        attributes.forEach((attributeKey, o) -> marshalers.add(KeyValueMarshaler.create(attributeKey, o)));
        return marshalers;
    }

    static KeyValueMarshaler create(AttributeKey<?> key, Object value) {
        byte[] keyUtf8 = MarshalerUtil.toBytes((String)key.getKey());
        ProtoEnumInfo valueType = ValueType.STRING;
        byte[] vStrUtf8 = EMPTY_BYTES;
        boolean vBool = false;
        long vInt64 = 0L;
        double vFloat64 = 0.0;
        switch (key.getType()) {
            case STRING: {
                valueType = ValueType.STRING;
                vStrUtf8 = MarshalerUtil.toBytes((String)((String)value));
                break;
            }
            case BOOLEAN: {
                valueType = ValueType.BOOL;
                vBool = (Boolean)value;
                break;
            }
            case LONG: {
                valueType = ValueType.INT64;
                vInt64 = (Long)value;
                break;
            }
            case DOUBLE: {
                valueType = ValueType.FLOAT64;
                vFloat64 = (Double)value;
                break;
            }
            case STRING_ARRAY: 
            case BOOLEAN_ARRAY: 
            case LONG_ARRAY: 
            case DOUBLE_ARRAY: {
                valueType = ValueType.STRING;
                try {
                    vStrUtf8 = JSON.std.asBytes(value);
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return new KeyValueMarshaler(keyUtf8, valueType, vStrUtf8, vBool, vInt64, vFloat64);
    }

    KeyValueMarshaler(byte[] keyUtf8, ProtoEnumInfo valueType, byte[] vStrUtf8, boolean vBool, long vInt64, double vFloat64) {
        super(KeyValueMarshaler.calculateSize(keyUtf8, valueType, vStrUtf8, vBool, vInt64, vFloat64));
        this.keyUtf8 = keyUtf8;
        this.valueType = valueType;
        this.vStrUtf8 = vStrUtf8;
        this.vBool = vBool;
        this.vInt64 = vInt64;
        this.vFloat64 = vFloat64;
    }

    protected void writeTo(Serializer output) throws IOException {
        output.serializeString(KeyValue.KEY, this.keyUtf8);
        output.serializeEnum(KeyValue.V_TYPE, this.valueType);
        output.serializeString(KeyValue.V_STR, this.vStrUtf8);
        output.serializeBool(KeyValue.V_BOOL, this.vBool);
        output.serializeInt64(KeyValue.V_INT64, this.vInt64);
        output.serializeDouble(KeyValue.V_FLOAT64, this.vFloat64);
    }

    private static int calculateSize(byte[] keyUtf8, ProtoEnumInfo valueType, byte[] vStrUtf8, boolean vBool, long vInt64, double vFloat64) {
        int size = 0;
        size += MarshalerUtil.sizeBytes((ProtoFieldInfo)KeyValue.KEY, (byte[])keyUtf8);
        size += MarshalerUtil.sizeEnum((ProtoFieldInfo)KeyValue.V_TYPE, (ProtoEnumInfo)valueType);
        size += MarshalerUtil.sizeBytes((ProtoFieldInfo)KeyValue.V_STR, (byte[])vStrUtf8);
        size += MarshalerUtil.sizeBool((ProtoFieldInfo)KeyValue.V_BOOL, (boolean)vBool);
        size += MarshalerUtil.sizeInt64((ProtoFieldInfo)KeyValue.V_INT64, (long)vInt64);
        return size += MarshalerUtil.sizeDouble((ProtoFieldInfo)KeyValue.V_FLOAT64, (double)vFloat64);
    }
}

