/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lifecycle;

public enum ComponentStatus {
    INSTANTIATED,
    INITIALIZING,
    RUNNING,
    STOPPING,
    TERMINATED,
    FAILED;


    public boolean needToDestroyFailedCache() {
        return this == FAILED;
    }

    public boolean startAllowed() {
        return this == INSTANTIATED;
    }

    public boolean needToInitializeBeforeStart() {
        return this == TERMINATED;
    }

    public boolean stopAllowed() {
        switch (this) {
            case INSTANTIATED: 
            case TERMINATED: 
            case STOPPING: 
            case INITIALIZING: {
                return false;
            }
        }
        return true;
    }

    public boolean allowInvocations() {
        return this == RUNNING;
    }

    public boolean startingUp() {
        return this == INITIALIZING || this == INSTANTIATED;
    }

    public boolean isTerminated() {
        return this == TERMINATED;
    }

    public boolean isStopping() {
        return this == STOPPING;
    }
}

