/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.analyzer.impl.SimpleLuceneAnalyzerReference;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkExecutor;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class AddWorkExecutor
implements LuceneWorkExecutor {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    protected final Workspace workspace;

    AddWorkExecutor(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public void performWork(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor) {
        IndexedTypeIdentifier entityType = work.getEntityType();
        DocumentBuilderIndexedEntity documentBuilder = this.workspace.getDocumentBuilder(entityType);
        Map<String, String> fieldToAnalyzerMap = work.getFieldToAnalyzerMap();
        ScopedAnalyzerReference analyzerReference = documentBuilder.getAnalyzerReference();
        analyzerReference = AddWorkExecutor.updateAnalyzerMappings(this.workspace, analyzerReference, fieldToAnalyzerMap);
        if (log.isTraceEnabled()) {
            log.trace("add to Lucene index: " + entityType + "#" + work.getId() + ":" + work.getDocument());
        }
        try {
            delegate.addDocument(work.getDocument(), analyzerReference);
            this.workspace.notifyWorkApplied(work);
        }
        catch (IOException e) {
            throw new SearchException("Unable to add to Lucene index: " + entityType + "#" + work.getId(), e);
        }
        if (monitor != null) {
            monitor.documentsAdded(1L);
        }
    }

    static ScopedAnalyzerReference updateAnalyzerMappings(Workspace workspace, ScopedAnalyzerReference scopedAnalyzerReference, Map<String, String> fieldToAnalyzerMap) {
        if (fieldToAnalyzerMap == null || fieldToAnalyzerMap.isEmpty()) {
            return scopedAnalyzerReference;
        }
        ScopedAnalyzerReference.CopyBuilder copyBuilder = scopedAnalyzerReference.startCopy();
        for (Map.Entry<String, String> entry : fieldToAnalyzerMap.entrySet()) {
            Analyzer analyzer = workspace.getAnalyzer(entry.getValue());
            if (analyzer == null) {
                log.unableToRetrieveNamedAnalyzer(entry.getValue());
                continue;
            }
            copyBuilder.addAnalyzerReference(entry.getKey(), new SimpleLuceneAnalyzerReference(analyzer));
        }
        return copyBuilder.build();
    }
}

