/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncoderPersister;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.JournalUpdateCallback;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.utils.collections.SparseArrayLinkedList;

public interface Journal
extends ActiveMQComponent {
    public void setRemoveExtraFilesOnLoad(boolean var1);

    public boolean isRemoveExtraFilesOnLoad();

    default public boolean isHistory() {
        return false;
    }

    public void appendAddRecord(long var1, byte var3, byte[] var4, boolean var5) throws Exception;

    default public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        this.appendAddRecord(id, recordType, EncoderPersister.getInstance(), record, sync);
    }

    default public Journal setHistoryFolder(File historyFolder, long maxBytes, long period) throws Exception {
        return this;
    }

    public void appendAddRecord(long var1, byte var3, Persister var4, Object var5, boolean var6) throws Exception;

    public void appendAddRecord(long var1, byte var3, Persister var4, Object var5, boolean var6, IOCompletion var7) throws Exception;

    public void appendAddEvent(long var1, byte var3, Persister var4, Object var5, boolean var6, IOCompletion var7) throws Exception;

    default public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.appendAddRecord(id, recordType, EncoderPersister.getInstance(), record, sync, completionCallback);
    }

    default public void replaceableRecord(byte recordType) {
    }

    public void appendUpdateRecord(long var1, byte var3, byte[] var4, boolean var5) throws Exception;

    public void tryAppendUpdateRecord(long var1, byte var3, byte[] var4, JournalUpdateCallback var5, boolean var6, boolean var7) throws Exception;

    default public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        this.appendUpdateRecord(id, recordType, EncoderPersister.getInstance(), record, sync);
    }

    default public void tryAppendUpdateRecord(long id, byte recordType, EncodingSupport record, JournalUpdateCallback updateCallback, boolean sync, boolean replaceableRecord) throws Exception {
        this.tryAppendUpdateRecord(id, recordType, EncoderPersister.getInstance(), record, updateCallback, sync, replaceableRecord);
    }

    public void appendUpdateRecord(long var1, byte var3, Persister var4, Object var5, boolean var6) throws Exception;

    public void tryAppendUpdateRecord(long var1, byte var3, Persister var4, Object var5, JournalUpdateCallback var6, boolean var7, boolean var8) throws Exception;

    default public IOCriticalErrorListener getCriticalErrorListener() {
        return null;
    }

    default public Journal setCriticalErrorListener(IOCriticalErrorListener criticalErrorListener) {
        return this;
    }

    default public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.appendUpdateRecord(id, recordType, EncoderPersister.getInstance(), record, sync, completionCallback);
    }

    default public void tryAppendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync, boolean replaceableUpdate, JournalUpdateCallback updateCallback, IOCompletion completionCallback) throws Exception {
        this.tryAppendUpdateRecord(id, recordType, EncoderPersister.getInstance(), record, sync, replaceableUpdate, updateCallback, completionCallback);
    }

    public void appendUpdateRecord(long var1, byte var3, Persister var4, Object var5, boolean var6, IOCompletion var7) throws Exception;

    public void tryAppendUpdateRecord(long var1, byte var3, Persister var4, Object var5, boolean var6, boolean var7, JournalUpdateCallback var8, IOCompletion var9) throws Exception;

    public void appendDeleteRecord(long var1, boolean var3) throws Exception;

    public void tryAppendDeleteRecord(long var1, JournalUpdateCallback var3, boolean var4) throws Exception;

    public void appendDeleteRecord(long var1, boolean var3, IOCompletion var4) throws Exception;

    public void tryAppendDeleteRecord(long var1, boolean var3, JournalUpdateCallback var4, IOCompletion var5) throws Exception;

    public void appendAddRecordTransactional(long var1, long var3, byte var5, byte[] var6) throws Exception;

    default public void appendAddRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        this.appendAddRecordTransactional(txID, id, recordType, EncoderPersister.getInstance(), record);
    }

    public void appendAddRecordTransactional(long var1, long var3, byte var5, Persister var6, Object var7) throws Exception;

    public void appendUpdateRecordTransactional(long var1, long var3, byte var5, byte[] var6) throws Exception;

    default public void appendUpdateRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        this.appendUpdateRecordTransactional(txID, id, recordType, EncoderPersister.getInstance(), record);
    }

    public void appendUpdateRecordTransactional(long var1, long var3, byte var5, Persister var6, Object var7) throws Exception;

    public void appendDeleteRecordTransactional(long var1, long var3, byte[] var5) throws Exception;

    public void appendDeleteRecordTransactional(long var1, long var3, EncodingSupport var5) throws Exception;

    public void appendDeleteRecordTransactional(long var1, long var3) throws Exception;

    public void appendCommitRecord(long var1, boolean var3) throws Exception;

    public void appendCommitRecord(long var1, boolean var3, IOCompletion var4) throws Exception;

    public void appendCommitRecord(long var1, boolean var3, IOCompletion var4, boolean var5) throws Exception;

    public void appendPrepareRecord(long var1, EncodingSupport var3, boolean var4) throws Exception;

    public void appendPrepareRecord(long var1, EncodingSupport var3, boolean var4, IOCompletion var5) throws Exception;

    public void appendPrepareRecord(long var1, byte[] var3, boolean var4) throws Exception;

    public void appendRollbackRecord(long var1, boolean var3) throws Exception;

    public void appendRollbackRecord(long var1, boolean var3, IOCompletion var4) throws Exception;

    public JournalLoadInformation load(LoaderCallback var1) throws Exception;

    public JournalLoadInformation loadInternalOnly() throws Exception;

    public JournalLoadInformation loadSyncOnly(JournalState var1) throws Exception;

    public void lineUpContext(IOCompletion var1);

    default public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure) throws Exception {
        return this.load(committedRecords, preparedTransactions, transactionFailure, true);
    }

    public JournalLoadInformation load(List<RecordInfo> var1, List<PreparedTransactionInfo> var2, TransactionFailureCallback var3, boolean var4) throws Exception;

    default public JournalLoadInformation load(SparseArrayLinkedList<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure) throws Exception {
        return this.load(committedRecords, preparedTransactions, transactionFailure, true);
    }

    public JournalLoadInformation load(SparseArrayLinkedList<RecordInfo> var1, List<PreparedTransactionInfo> var2, TransactionFailureCallback var3, boolean var4) throws Exception;

    public int getAlignment() throws Exception;

    public int getNumberOfRecords();

    public int getUserVersion();

    public Map<Long, JournalFile> createFilesForBackupSync(long[] var1) throws Exception;

    public void synchronizationLock();

    public void synchronizationUnlock();

    default public void processBackup() {
    }

    default public void processBackupCleanup() {
    }

    public void forceMoveNextFile() throws Exception;

    default public void forceBackup(int timeout, TimeUnit unit) throws Exception {
    }

    public JournalFile[] getDataFiles();

    public SequentialFileFactory getFileFactory();

    public int getFileSize();

    public void scheduleCompactAndBlock(int var1) throws Exception;

    public void replicationSyncPreserveOldFiles();

    public void replicationSyncFinished();

    public void flush() throws Exception;

    public long getMaxRecordSize();

    public static enum JournalState {
        STOPPED,
        STARTED,
        SYNCING,
        SYNCING_UP_TO_DATE,
        LOADED;

    }
}

