/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import java.time.Duration;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.extension.mod_cluster.ProxyConfigurationResourceDefinition;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.mod_cluster.undertow.UndertowEventHandlerAdapterConfiguration;
import org.wildfly.mod_cluster.undertow.UndertowEventHandlerAdapterService;
import org.wildfly.mod_cluster.undertow.UndertowEventHandlerAdapterServiceNameProvider;

public class UndertowEventHandlerAdapterServiceConfigurator
extends UndertowEventHandlerAdapterServiceNameProvider
implements CapabilityServiceConfigurator,
UndertowEventHandlerAdapterConfiguration {
    private final String proxyName;
    private final String listenerName;
    private final Duration statusInterval;
    private volatile Supplier<ContainerEventHandler> eventHandler;
    private volatile SupplierDependency<SuspendController> suspendController;
    private volatile SupplierDependency<UndertowService> service;
    private volatile SupplierDependency<UndertowListener> listener;

    public UndertowEventHandlerAdapterServiceConfigurator(String proxyName, String listenerName, Duration statusInterval) {
        super(proxyName);
        this.proxyName = proxyName;
        this.listenerName = listenerName;
        this.statusInterval = statusInterval;
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.service = new ServiceSupplierDependency(support.getCapabilityServiceName("org.wildfly.undertow"));
        this.listener = new ServiceSupplierDependency(support.getCapabilityServiceName("org.wildfly.undertow.listener", new String[]{this.listenerName}));
        this.suspendController = new ServiceSupplierDependency(support.getCapabilityServiceName("org.wildfly.server.suspend-controller"));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = new AsyncServiceConfigurator(this.getServiceName()).build(target);
        new CompositeDependency(new Dependency[]{this.service, this.listener, this.suspendController}).register(builder);
        this.eventHandler = builder.requires(ProxyConfigurationResourceDefinition.Capability.SERVICE.getDefinition().getCapabilityServiceName(new String[]{this.proxyName}));
        UndertowEventHandlerAdapterService service = new UndertowEventHandlerAdapterService(this);
        return builder.setInstance((Service)service);
    }

    @Override
    public Duration getStatusInterval() {
        return this.statusInterval;
    }

    @Override
    public UndertowService getUndertowService() {
        return (UndertowService)this.service.get();
    }

    @Override
    public ContainerEventHandler getContainerEventHandler() {
        return this.eventHandler.get();
    }

    @Override
    public SuspendController getSuspendController() {
        return (SuspendController)this.suspendController.get();
    }

    @Override
    public UndertowListener getListener() {
        return (UndertowListener)this.listener.get();
    }

    @Override
    public Server getServer() {
        return ((UndertowListener)this.listener.get()).getServer();
    }
}

