/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import javax.net.ssl.SSLContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.DiscoveryService;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.EJBClientContextService;
import org.jboss.as.ejb3.remote.RemotingProfileService;
import org.jboss.as.network.OutboundConnection;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.discovery.Discovery;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.MatchRule;
import org.xnio.OptionMap;

public class EjbClientContextSetupProcessor
implements DeploymentUnitProcessor {
    private static final AuthenticationContextConfigurationClient CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        RegistrationService registrationService = new RegistrationService(module);
        ServiceName registrationServiceName = deploymentUnit.getServiceName().append(new String[]{"ejb3", "client-context", "registration-service"});
        ServiceName profileServiceName = this.getProfileServiceName(phaseContext);
        ServiceBuilder builder = phaseContext.getServiceTarget().addService(registrationServiceName, (Service)registrationService).addDependency(this.getEJBClientContextServiceName(phaseContext), EJBClientContextService.class, registrationService.ejbClientContextInjectedValue).addDependency(this.getDiscoveryServiceName(phaseContext), Discovery.class, registrationService.discoveryInjector);
        if (profileServiceName != null) {
            builder.addDependency(profileServiceName, RemotingProfileService.class, registrationService.profileServiceInjectedValue);
        }
        builder.install();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            component.addDependency(registrationServiceName);
        }
    }

    private ServiceName getEJBClientContextServiceName(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parentDeploymentUnit = deploymentUnit.getParent();
        ServiceName serviceName = parentDeploymentUnit != null ? (ServiceName)parentDeploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE_NAME) : (ServiceName)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE_NAME);
        if (serviceName != null) {
            return serviceName;
        }
        return EJBClientContextService.DEFAULT_SERVICE_NAME;
    }

    private ServiceName getDiscoveryServiceName(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parentDeploymentUnit = deploymentUnit.getParent();
        if (parentDeploymentUnit != null) {
            return DiscoveryService.BASE_NAME.append(new String[]{parentDeploymentUnit.getName()});
        }
        return DiscoveryService.BASE_NAME.append(new String[]{deploymentUnit.getName()});
    }

    private ServiceName getProfileServiceName(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parentDeploymentUnit = deploymentUnit.getParent();
        if (parentDeploymentUnit != null) {
            return (ServiceName)parentDeploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_REMOTING_PROFILE_SERVICE_NAME);
        }
        return (ServiceName)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_REMOTING_PROFILE_SERVICE_NAME);
    }

    private static final class RegistrationService
    implements Service<Void> {
        private final Module module;
        final InjectedValue<EJBClientContextService> ejbClientContextInjectedValue = new InjectedValue();
        final InjectedValue<Discovery> discoveryInjector = new InjectedValue();
        final InjectedValue<RemotingProfileService> profileServiceInjectedValue = new InjectedValue();

        private RegistrationService(Module module) {
            this.module = module;
        }

        public void start(StartContext context) throws StartException {
            try {
                AccessController.doPrivileged(() -> {
                    EJBClientContextService ejbClientContextService = (EJBClientContextService)this.ejbClientContextInjectedValue.getValue();
                    EJBClientContext ejbClientContext = ejbClientContextService.getClientContext();
                    AuthenticationContext ejbClientClustersAuthenticationContext = ejbClientContextService.getClustersAuthenticationContext();
                    ModuleClassLoader classLoader = this.module.getClassLoader();
                    EjbLogger.DEPLOYMENT_LOGGER.debugf("Registering EJB client context %s for classloader %s", ejbClientContext, classLoader);
                    ContextManager authenticationContextManager = AuthenticationContext.getContextManager();
                    RemotingProfileService profileService = (RemotingProfileService)this.profileServiceInjectedValue.getOptionalValue();
                    if (profileService != null || ejbClientClustersAuthenticationContext != null) {
                        AuthenticationContext authenticationContext = (AuthenticationContext)authenticationContextManager.getClassLoaderDefault((ClassLoader)classLoader);
                        if (authenticationContext == null) {
                            authenticationContext = (AuthenticationContext)authenticationContextManager.get();
                        }
                        AuthenticationContext finalAuthenticationContext = authenticationContext;
                        authenticationContextManager.setClassLoaderDefaultSupplier((ClassLoader)classLoader, () -> {
                            AuthenticationContext transformed = finalAuthenticationContext;
                            if (profileService != null) {
                                for (RemotingProfileService.RemotingConnectionSpec connectionSpec : profileService.getConnectionSpecs()) {
                                    transformed = RegistrationService.transformOne(connectionSpec, transformed);
                                }
                            }
                            if (ejbClientClustersAuthenticationContext != null) {
                                transformed = ejbClientClustersAuthenticationContext.with(transformed);
                            }
                            return transformed;
                        });
                    }
                    EJBClientContext.getContextManager().setClassLoaderDefault((ClassLoader)classLoader, (Contextual)ejbClientContext);
                    Discovery.getContextManager().setClassLoaderDefault((ClassLoader)classLoader, (Contextual)this.discoveryInjector.getValue());
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw (StartException)e.getCause();
            }
        }

        public void stop(StopContext context) {
            AccessController.doPrivileged(() -> {
                ModuleClassLoader classLoader = this.module.getClassLoader();
                EjbLogger.DEPLOYMENT_LOGGER.debugf("unRegistering EJB client context for classloader %s", classLoader);
                EJBClientContext.getContextManager().setClassLoaderDefault((ClassLoader)classLoader, null);
                Discovery.getContextManager().setClassLoaderDefault((ClassLoader)classLoader, null);
                AuthenticationContext.getContextManager().setClassLoaderDefault((ClassLoader)classLoader, null);
                return null;
            });
        }

        public Void getValue() throws IllegalStateException, IllegalArgumentException {
            return null;
        }

        private static AuthenticationContext transformOne(RemotingProfileService.RemotingConnectionSpec connectionSpec, AuthenticationContext context) {
            String path;
            int port;
            String host;
            OutboundConnection connectionService = (OutboundConnection)connectionSpec.getInjector().getValue();
            AuthenticationConfiguration authenticationConfiguration = connectionService.getAuthenticationConfiguration();
            SSLContext sslContext = connectionService.getSSLContext();
            URI destinationUri = connectionService.getDestinationUri();
            MatchRule rule = MatchRule.ALL;
            String scheme = destinationUri.getScheme();
            if (scheme != null) {
                rule = rule.matchProtocol(scheme);
            }
            if ((host = destinationUri.getHost()) != null) {
                rule = rule.matchHost(host);
            }
            if ((port = destinationUri.getPort()) != -1) {
                rule = rule.matchPort(port);
            }
            if ((path = destinationUri.getPath()) != null && !path.isEmpty()) {
                rule = rule.matchPath(path);
            }
            MatchRule ejbRule = rule.matchAbstractType("ejb", "jboss");
            MatchRule jtaRule = rule.matchAbstractType("jta", "jboss");
            OptionMap connectOptions = connectionSpec.getConnectOptions();
            authenticationConfiguration = RemotingOptions.mergeOptionsIntoAuthenticationConfiguration((OptionMap)connectOptions, (AuthenticationConfiguration)authenticationConfiguration);
            AuthenticationConfiguration ejbConfiguration = CLIENT.getAuthenticationConfiguration(destinationUri, context, -1, "ejb", "jboss");
            AuthenticationConfiguration jtaConfiguration = CLIENT.getAuthenticationConfiguration(destinationUri, context, -1, "jta", "jboss");
            if (sslContext == null) {
                try {
                    sslContext = CLIENT.getSSLContext(destinationUri, context);
                }
                catch (GeneralSecurityException e) {
                    throw EjbLogger.ROOT_LOGGER.failedToObtainSSLContext(e);
                }
            }
            SSLContext finalSSLContext = sslContext;
            AuthenticationContext mergedAuthenticationContext = context.with(0, ejbRule, ejbConfiguration.with(authenticationConfiguration)).with(jtaRule, jtaConfiguration.with(authenticationConfiguration));
            return mergedAuthenticationContext.withSsl(0, rule, () -> finalSSLContext);
        }
    }
}

