/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.streams.stages;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.streams.Engine;
import io.smallrye.mutiny.streams.operators.ProcessingStage;
import io.smallrye.mutiny.streams.operators.ProcessingStageFactory;
import io.smallrye.mutiny.streams.utils.Casts;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;

public class FlatMapCompletionStageFactory
implements ProcessingStageFactory<Stage.FlatMapCompletionStage> {
    @Override
    public <I, O> ProcessingStage<I, O> create(Engine engine, Stage.FlatMapCompletionStage stage) {
        Function mapper = Casts.cast(Objects.requireNonNull(stage).getMapper());
        return new FlatMapCompletionStage(mapper);
    }

    private static class FlatMapCompletionStage<I, O>
    implements ProcessingStage<I, O> {
        private final Function<I, CompletionStage<O>> mapper;

        private FlatMapCompletionStage(Function<I, CompletionStage<O>> mapper) {
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public Multi<O> apply(Multi<I> source) {
            return source.onItem().transformToUni(item -> {
                if (item == null) {
                    return Uni.createFrom().failure(NullPointerException::new);
                }
                CompletionStage<O> result = this.mapper.apply(item);
                if (result == null) {
                    return Uni.createFrom().failure(NullPointerException::new);
                }
                return Uni.createFrom().completionStage(result).onItem().ifNull().failWith(NullPointerException::new);
            }).concatenate();
        }
    }
}

