/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.processors.UnicastProcessor;
import io.smallrye.mutiny.subscription.MultiEmitter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MultiEmitterProcessor<T>
implements Processor<T, T>,
MultiEmitter<T> {
    private final UnicastProcessor<T> processor;
    private final AtomicReference<Runnable> onTermination = new AtomicReference();
    private final AtomicBoolean terminated = new AtomicBoolean();
    private final AtomicLong requested = new AtomicLong();

    private MultiEmitterProcessor() {
        this.processor = UnicastProcessor.create();
    }

    public static <T> MultiEmitterProcessor<T> create() {
        return new MultiEmitterProcessor<T>();
    }

    @Override
    public MultiEmitter<T> emit(T item) {
        this.onNext(item);
        return this;
    }

    @Override
    public void fail(Throwable failure) {
        this.onError(failure);
    }

    @Override
    public void complete() {
        this.onComplete();
    }

    @Override
    public MultiEmitter<T> onTermination(Runnable onTermination) {
        this.onTermination.set(onTermination);
        return this;
    }

    @Override
    public boolean isCancelled() {
        return this.terminated.get();
    }

    @Override
    public long requested() {
        return this.requested.get();
    }

    public void subscribe(final Subscriber<? super T> subscriber) {
        ((AbstractMulti)this.processor).subscribe(new Subscriber<T>(){

            public void onSubscribe(final Subscription subscription) {
                subscriber.onSubscribe(new Subscription(){

                    public void request(long l) {
                        Subscriptions.add(MultiEmitterProcessor.this.requested, l);
                        subscription.request(l);
                    }

                    public void cancel() {
                        subscription.cancel();
                        MultiEmitterProcessor.this.fireTermination();
                    }
                });
            }

            public void onNext(T item) {
                subscriber.onNext(item);
            }

            public void onError(Throwable failure) {
                subscriber.onError(failure);
                MultiEmitterProcessor.this.fireTermination();
            }

            public void onComplete() {
                subscriber.onComplete();
                MultiEmitterProcessor.this.fireTermination();
            }
        });
    }

    private void fireTermination() {
        Runnable runnable;
        if (this.terminated.compareAndSet(false, true) && (runnable = (Runnable)this.onTermination.getAndSet(null)) != null) {
            runnable.run();
        }
    }

    public void onSubscribe(Subscription subscription) {
        this.processor.onSubscribe(subscription);
    }

    public void onNext(T item) {
        Subscriptions.subtract(this.requested, 1L);
        this.processor.onNext(item);
    }

    public void onError(Throwable failure) {
        this.processor.onError(failure);
    }

    public void onComplete() {
        this.processor.onComplete();
    }

    public Multi<T> toMulti() {
        return Multi.createFrom().publisher(this);
    }
}

