/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.digest;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism._private.ElytronMessages;

public class NonceManager {
    private static final int PREFIX_LENGTH = 12;
    private final ScheduledExecutorService executor;
    private final AtomicInteger nonceCounter = new AtomicInteger();
    private final Map<String, NonceState> usedNonces = new HashMap<String, NonceState>();
    private final byte[] privateKey;
    private final long validityPeriodNano;
    private final long nonceSessionTime;
    private final boolean singleUse;
    private final String algorithm;
    private ElytronMessages log;

    @Deprecated
    NonceManager(long validityPeriod, long nonceSessionTime, boolean singleUse, int keySize, String algorithm) {
        this.validityPeriodNano = validityPeriod * 1000000L;
        this.nonceSessionTime = nonceSessionTime;
        this.singleUse = singleUse;
        this.algorithm = algorithm;
        this.log = ElytronMessages.log;
        this.privateKey = new byte[keySize];
        new SecureRandom().nextBytes(this.privateKey);
        ScheduledThreadPoolExecutor INSTANCE = new ScheduledThreadPoolExecutor(1);
        INSTANCE.setRemoveOnCancelPolicy(true);
        INSTANCE.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor = INSTANCE;
    }

    NonceManager(long validityPeriod, long nonceSessionTime, boolean singleUse, int keySize, String algorithm, ElytronMessages log) {
        this.validityPeriodNano = validityPeriod * 1000000L;
        this.nonceSessionTime = nonceSessionTime;
        this.singleUse = singleUse;
        this.algorithm = algorithm;
        this.log = log;
        this.privateKey = new byte[keySize];
        new SecureRandom().nextBytes(this.privateKey);
        ScheduledThreadPoolExecutor INSTANCE = new ScheduledThreadPoolExecutor(1);
        INSTANCE.setRemoveOnCancelPolicy(true);
        INSTANCE.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor = INSTANCE;
    }

    NonceManager(long validityPeriod, long nonceSessionTime, boolean singleUse, int keySize, String algorithm, ElytronMessages log, ScheduledExecutorService customExecutor) {
        this.validityPeriodNano = validityPeriod * 1000000L;
        this.nonceSessionTime = nonceSessionTime;
        this.singleUse = singleUse;
        this.algorithm = algorithm;
        this.log = log;
        this.privateKey = new byte[keySize];
        new SecureRandom().nextBytes(this.privateKey);
        if (customExecutor == null) {
            ScheduledThreadPoolExecutor INSTANCE = new ScheduledThreadPoolExecutor(1);
            INSTANCE.setRemoveOnCancelPolicy(true);
            INSTANCE.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.executor = INSTANCE;
        } else {
            this.executor = customExecutor;
        }
    }

    String generateNonce() {
        return this.generateNonce(null);
    }

    String generateNonce(byte[] salt) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm);
            ByteBuffer byteBuffer = ByteBuffer.allocate(12 + messageDigest.getDigestLength());
            byteBuffer.putInt(this.nonceCounter.incrementAndGet());
            byteBuffer.putLong(System.nanoTime());
            byteBuffer.put(this.digest(byteBuffer.array(), 0, 12, salt, messageDigest));
            String nonce = ByteIterator.ofBytes(byteBuffer.array()).base64Encode().drainToString();
            if (this.log.isTraceEnabled()) {
                String saltString = salt == null ? "null" : ByteIterator.ofBytes(salt).hexEncode().drainToString();
                this.log.tracef("New nonce generated %s, using seed %s", (Object)nonce, (Object)saltString);
            }
            return nonce;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] digest(byte[] prefix, int prefixOffset, int prefixLength, byte[] salt, MessageDigest messageDigest) throws DigestException {
        messageDigest.update(prefix, prefixOffset, prefixLength);
        if (salt != null) {
            messageDigest.update(salt);
        }
        return messageDigest.digest(this.privateKey);
    }

    boolean useNonce(String nonce, int nonceCount) throws AuthenticationMechanismException {
        return this.useNonce(nonce, null, nonceCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean useNonce(String nonce, byte[] salt, int nonceCount) throws AuthenticationMechanismException {
        try {
            byte[] expectedNonce;
            MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm);
            ByteIterator byteIterator = CodePointIterator.ofChars(nonce.toCharArray()).base64Decode();
            byte[] nonceBytes = byteIterator.drain();
            if (nonceBytes.length != 12 + messageDigest.getDigestLength()) {
                throw this.log.invalidNonceLength();
            }
            byte[] nonceBytesWithoutPrefix = Arrays.copyOfRange(nonceBytes, 12, nonceBytes.length);
            if (!MessageDigest.isEqual(nonceBytesWithoutPrefix, expectedNonce = this.digest(nonceBytes, 0, 12, salt, messageDigest))) {
                if (!this.log.isTraceEnabled()) return false;
                String saltString = salt == null ? "null" : ByteIterator.ofBytes(salt).hexEncode().drainToString();
                this.log.tracef("Nonce %s rejected due to failed comparison using secret key with seed %s.", (Object)nonce, (Object)saltString);
                return false;
            }
            long age = System.nanoTime() - ByteBuffer.wrap(nonceBytes, 4, 8).getLong();
            if (nonceCount > 0) {
                Map<String, NonceState> map = this.usedNonces;
                synchronized (map) {
                    NonceState nonceState = this.usedNonces.get(nonce);
                    if (nonceState != null && nonceState.highestNonceCount < 0) {
                        this.log.tracef("Nonce %s rejected due to previously being used without a nonce count", (Object)nonce);
                        return false;
                    }
                    if (nonceState != null) {
                        if (nonceCount <= nonceState.highestNonceCount) {
                            this.log.tracef("Nonce %s rejected due to highest seen nonce count %d being equal to or higher than the nonce count received %d", (Object)nonce, (Object)nonceState.highestNonceCount, (Object)nonceCount);
                            return false;
                        }
                        if (!nonceState.futureCleanup.cancel(true)) {
                            this.log.tracef("Nonce %s rejected as unable to cancel clean up, likely at expiration time", (Object)nonce);
                            return false;
                        }
                        nonceState.highestNonceCount = nonceCount;
                    } else {
                        if (age < 0L || age > this.validityPeriodNano) {
                            this.log.tracef("Nonce %s rejected due to age %d (ns) being less than 0 or greater than the validity period %d (ns)", (Object)nonce, (Object)age, (Object)this.validityPeriodNano);
                            return false;
                        }
                        nonceState = new NonceState();
                        nonceState.highestNonceCount = nonceCount;
                        this.usedNonces.put(nonce, nonceState);
                        if (this.log.isTraceEnabled()) {
                            this.log.tracef("Currently %d nonces being tracked", this.usedNonces.size());
                        }
                    }
                    nonceState.futureCleanup = this.executor.schedule(() -> {
                        Map<String, NonceState> map = this.usedNonces;
                        synchronized (map) {
                            this.usedNonces.remove(nonce);
                        }
                    }, this.nonceSessionTime, TimeUnit.MILLISECONDS);
                    return true;
                }
            }
            if (age < 0L || age > this.validityPeriodNano) {
                this.log.tracef("Nonce %s rejected due to age %d (ns) being less than 0 or greater than the validity period %d (ns)", (Object)nonce, (Object)age, (Object)this.validityPeriodNano);
                return false;
            }
            if (!this.singleUse) return true;
            Map<String, NonceState> map = this.usedNonces;
            synchronized (map) {
                NonceState nonceState = this.usedNonces.get(nonce);
                if (nonceState != null) {
                    this.log.tracef("Nonce %s rejected due to previously being used", (Object)nonce);
                    return false;
                }
                nonceState = new NonceState();
                this.usedNonces.put(nonce, nonceState);
                if (this.log.isTraceEnabled()) {
                    this.log.tracef("Currently %d nonces being tracked", this.usedNonces.size());
                }
                this.executor.schedule(() -> {
                    Map<String, NonceState> map = this.usedNonces;
                    synchronized (map) {
                        this.usedNonces.remove(nonce);
                    }
                }, this.validityPeriodNano - age, TimeUnit.NANOSECONDS);
                return true;
            }
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private static class NonceState {
        private ScheduledFuture<?> futureCleanup;
        private int highestNonceCount = -1;

        private NonceState() {
        }
    }
}

