/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.messaging.activemq.AbstractTransportDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryUpdateJndiHandler;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryAdd;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryRemove;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryService;

public class ExternalConnectionFactoryDefinition
extends PersistentResourceDefinition {
    private static StringListAttributeDefinition CONNECTORS = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(ConnectionFactoryAttributes.Common.CONNECTORS).setCapabilityReference((CapabilityReferenceRecorder)new AbstractTransportDefinition.TransportCapabilityReferenceRecorder("org.wildfly.messaging.activemq.external.connection-factory", "org.wildfly.messaging.activemq.connector", true))).build();
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.messaging.activemq.external.connection-factory", (boolean)true, ExternalConnectionFactoryService.class).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.HA, ConnectionFactoryAttributes.Regular.FACTORY_TYPE, ConnectionFactoryAttributes.Common.DISCOVERY_GROUP, CONNECTORS, ConnectionFactoryAttributes.Common.ENTRIES, ConnectionFactoryAttributes.External.ENABLE_AMQ1_PREFIX, ConnectionFactoryAttributes.Common.CLIENT_FAILURE_CHECK_PERIOD, ConnectionFactoryAttributes.Common.CONNECTION_TTL, CommonAttributes.CALL_TIMEOUT, CommonAttributes.CALL_FAILOVER_TIMEOUT, ConnectionFactoryAttributes.Common.CONSUMER_WINDOW_SIZE, ConnectionFactoryAttributes.Common.CONSUMER_MAX_RATE, ConnectionFactoryAttributes.Common.CONFIRMATION_WINDOW_SIZE, ConnectionFactoryAttributes.Common.PRODUCER_WINDOW_SIZE, ConnectionFactoryAttributes.Common.PRODUCER_MAX_RATE, ConnectionFactoryAttributes.Common.PROTOCOL_MANAGER_FACTORY, ConnectionFactoryAttributes.Common.COMPRESS_LARGE_MESSAGES, ConnectionFactoryAttributes.Common.CACHE_LARGE_MESSAGE_CLIENT, CommonAttributes.MIN_LARGE_MESSAGE_SIZE, CommonAttributes.CLIENT_ID, ConnectionFactoryAttributes.Common.DUPS_OK_BATCH_SIZE, ConnectionFactoryAttributes.Common.TRANSACTION_BATCH_SIZE, ConnectionFactoryAttributes.Common.BLOCK_ON_ACKNOWLEDGE, ConnectionFactoryAttributes.Common.BLOCK_ON_NON_DURABLE_SEND, ConnectionFactoryAttributes.Common.BLOCK_ON_DURABLE_SEND, ConnectionFactoryAttributes.Common.AUTO_GROUP, ConnectionFactoryAttributes.Common.PRE_ACKNOWLEDGE, ConnectionFactoryAttributes.Common.RETRY_INTERVAL, ConnectionFactoryAttributes.Common.RETRY_INTERVAL_MULTIPLIER, CommonAttributes.MAX_RETRY_INTERVAL, ConnectionFactoryAttributes.Common.RECONNECT_ATTEMPTS, ConnectionFactoryAttributes.Common.FAILOVER_ON_INITIAL_CONNECTION, ConnectionFactoryAttributes.Common.CONNECTION_LOAD_BALANCING_CLASS_NAME, ConnectionFactoryAttributes.Common.USE_GLOBAL_POOLS, ConnectionFactoryAttributes.Common.SCHEDULED_THREAD_POOL_MAX_SIZE, ConnectionFactoryAttributes.Common.THREAD_POOL_MAX_SIZE, ConnectionFactoryAttributes.Common.GROUP_ID, ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST, ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST, ConnectionFactoryAttributes.Common.INITIAL_MESSAGE_PACKET_SIZE, ConnectionFactoryAttributes.Common.USE_TOPOLOGY};
    private final boolean registerRuntimeOnly;

    public ExternalConnectionFactoryDefinition(boolean registerRuntimeOnly) {
        super(new SimpleResourceDefinition.Parameters(MessagingExtension.CONNECTION_FACTORY_PATH, MessagingExtension.getResourceDescriptionResolver("connection-factory")).setCapabilities(new RuntimeCapability[]{CAPABILITY}).setAddHandler((OperationStepHandler)ExternalConnectionFactoryAdd.INSTANCE).setRemoveHandler((OperationStepHandler)ExternalConnectionFactoryRemove.INSTANCE));
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            ConnectionFactoryUpdateJndiHandler.registerOperations(registry, this.getResourceDescriptionResolver());
        }
    }
}

