/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.interfaces.RawPassword;

class RawDigestPassword
extends RawPassword
implements DigestPassword {
    private static final long serialVersionUID = 7084601864990731347L;
    private final String username;
    private final String realm;
    private final byte[] digest;

    RawDigestPassword(String algorithm, String username, String realm, byte[] digest) {
        super(algorithm);
        this.username = username;
        this.realm = realm;
        this.digest = digest;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    public RawDigestPassword clone() {
        return this;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)Arrays.hashCode(this.digest), (int)this.username.hashCode()), (int)this.realm.hashCode()), (int)this.getAlgorithm().hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RawDigestPassword)) {
            return false;
        }
        RawDigestPassword other = (RawDigestPassword)obj;
        return Arrays.equals(this.digest, other.digest) && this.username.equals(other.username) && this.realm.equals(other.realm) && this.getAlgorithm().equals(other.getAlgorithm());
    }
}

