/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.access.RbacSanityCheckOperation;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;

public class RoleMappingRemove
implements OperationStepHandler {
    private final WritableAuthorizerConfiguration authorizerConfiguration;

    private RoleMappingRemove(WritableAuthorizerConfiguration authorizerConfiguration) {
        this.authorizerConfiguration = authorizerConfiguration;
    }

    public static OperationStepHandler create(WritableAuthorizerConfiguration authorizerConfiguration) {
        return new RoleMappingRemove(authorizerConfiguration);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.removeResource(PathAddress.EMPTY_ADDRESS);
        if (resource == null) {
            throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(context.getCurrentAddress());
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String roleName = address.getLastElement().getValue();
        RbacSanityCheckOperation.addOperation(context);
        this.registerRuntimeRemove(context, roleName.toUpperCase(Locale.ENGLISH));
    }

    private void registerRuntimeRemove(OperationContext context, final String roleName) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Object undoKey = RoleMappingRemove.this.authorizerConfiguration.removeRoleMapping(roleName);
                if (undoKey == null) {
                    context.restartRequired();
                    throw DomainManagementLogger.ROOT_LOGGER.inconsistentRbacRuntimeState();
                }
                RoleMappingRemove.this.registerRollbackHandler(context, undoKey);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private void registerRollbackHandler(OperationContext context, final Object undoKey) {
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!RoleMappingRemove.this.authorizerConfiguration.undoRoleMappingRemove(undoKey)) {
                    context.restartRequired();
                }
            }
        });
    }
}

