/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYTRACEXT", length=4)
public interface TracingExtensionLogger
extends BasicLogger {
    public static final TracingExtensionLogger ROOT_LOGGER = (TracingExtensionLogger)Logger.getMessageLogger(TracingExtensionLogger.class, (String)TracingExtensionLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating MicroProfile OpenTracing Subsystem")
    public void activatingSubsystem();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=2, value="MicroProfile OpenTracing Subsystem is processing deployment")
    public void processingDeployment();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3, value="The deployment does not have Jakarta Contexts and Dependency Injection enabled. Skipping MicroProfile OpenTracing integration.")
    public void noCdiDeployment();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=4, value="Deriving service name based on the deployment unit's name: %s")
    public void serviceNameDerivedFromDeploymentUnit(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5, value="Registering the TracerInitializer filter")
    public void registeringTracerInitializer();

    @Message(id=6, value="Deployment %s requires use of the '%s' capability but it is not currently registered")
    public String deploymentRequiresCapability(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=7, value="No module found for deployment %s for resolving the tracer.")
    public void tracerResolverDeployementModuleNotFound(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8, value="Error using tracer resolver to resolve the tracer.")
    public void errorResolvingTracer(@Cause Exception var1);
}

