/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.StreamingChannel;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoOutputStream;

public interface ClientChannel
extends Channel,
StreamingChannel,
ClientSessionHolder {
    @Override
    default public ClientSession getClientSession() {
        return (ClientSession)this.getSession();
    }

    public String getChannelType();

    public IoOutputStream getAsyncIn();

    public IoInputStream getAsyncOut();

    public IoInputStream getAsyncErr();

    public OutputStream getInvertedIn();

    public InputStream getInvertedOut();

    public InputStream getInvertedErr();

    public void setIn(InputStream var1);

    public void setOut(OutputStream var1);

    public void setErr(OutputStream var1);

    public OpenFuture open() throws IOException;

    public Set<ClientChannelEvent> getChannelState();

    public Set<ClientChannelEvent> waitFor(Collection<ClientChannelEvent> var1, long var2);

    default public Set<ClientChannelEvent> waitFor(Collection<ClientChannelEvent> mask, Duration timeout) {
        return this.waitFor(mask, timeout != null ? timeout.toMillis() : -1L);
    }

    public Integer getExitStatus();

    public String getExitSignal();

    public static void validateCommandExitStatusCode(String command, Integer exitStatus) throws RemoteException {
        if (exitStatus == null) {
            throw new RemoteException("No exit status returned for command=" + command);
        }
        if (exitStatus != 0) {
            throw new RemoteException("Remote command failed (" + exitStatus + "): " + command, new ServerException(exitStatus.toString()));
        }
    }
}

