/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.okhttp;

import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.TlsUtil;
import io.opentelemetry.exporter.otlp.internal.okhttp.OkHttpExporter;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.OkHttpClient;

public final class OkHttpExporterBuilder<T extends Marshaler> {
    public static final long DEFAULT_TIMEOUT_SECS = 10L;
    private final String type;
    private String endpoint;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private boolean compressionEnabled = false;
    @Nullable
    private Headers.Builder headersBuilder;
    @Nullable
    private byte[] trustedCertificatesPem;

    public OkHttpExporterBuilder(String type, String defaultEndpoint) {
        this.type = type;
        this.endpoint = defaultEndpoint;
    }

    public OkHttpExporterBuilder<T> setTimeout(long timeout, TimeUnit unit) {
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public OkHttpExporterBuilder<T> setTimeout(Duration timeout) {
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OkHttpExporterBuilder<T> setEndpoint(String endpoint) {
        URI uri;
        try {
            uri = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint, must be a URL: " + endpoint, e);
        }
        if (uri.getScheme() == null || !uri.getScheme().equals("http") && !uri.getScheme().equals("https")) {
            throw new IllegalArgumentException("Invalid endpoint, must start with http:// or https://: " + uri);
        }
        this.endpoint = endpoint;
        return this;
    }

    public OkHttpExporterBuilder<T> setCompression(String compressionMethod) {
        if (compressionMethod.equals("gzip")) {
            this.compressionEnabled = true;
        }
        return this;
    }

    public OkHttpExporterBuilder<T> addHeader(String key, String value) {
        if (this.headersBuilder == null) {
            this.headersBuilder = new Headers.Builder();
        }
        this.headersBuilder.add(key, value);
        return this;
    }

    public OkHttpExporterBuilder<T> setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.trustedCertificatesPem = trustedCertificatesPem;
        return this;
    }

    public OkHttpExporter<T> build() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().callTimeout(Duration.ofNanos(this.timeoutNanos));
        if (this.trustedCertificatesPem != null) {
            try {
                X509TrustManager trustManager = TlsUtil.trustManager(this.trustedCertificatesPem);
                clientBuilder.sslSocketFactory(TlsUtil.sslSocketFactory(trustManager), trustManager);
            }
            catch (SSLException e) {
                throw new IllegalStateException("Could not set trusted certificate for OTLP HTTP connection, are they valid X.509 in PEM format?", e);
            }
        }
        Headers headers = this.headersBuilder == null ? null : this.headersBuilder.build();
        return new OkHttpExporter(this.type, clientBuilder.build(), this.endpoint, headers, this.compressionEnabled);
    }
}

