/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.OidcException;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unexpectedResponseCodeFromOidcProvider$str() {
        return "ELY23000: Unexpected HTTP status code in response from OIDC provider \"%d\"";
    }

    @Override
    public final OidcException unexpectedResponseCodeFromOidcProvider(int responseCode) {
        OidcException result = new OidcException(String.format(this.getLoggingLocale(), this.unexpectedResponseCodeFromOidcProvider$str(), responseCode));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String noEntityInResponse$str() {
        return "ELY23001: No entity in response from OIDC provider";
    }

    @Override
    public final OidcException noEntityInResponse() {
        OidcException result = new OidcException(String.format(this.getLoggingLocale(), this.noEntityInResponse$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedErrorSendingRequestToOidcProvider$str() {
        return "ELY23002: Unexpected error sending request to OIDC provider";
    }

    @Override
    public final OidcException unexpectedErrorSendingRequestToOidcProvider(Exception cause) {
        OidcException result = new OidcException(String.format(this.getLoggingLocale(), this.unexpectedErrorSendingRequestToOidcProvider$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String providerUrlOrAuthServerUrlNeedsToBeConfigured$str() {
        return "ELY23003: Either provider-url or auth-server-url needs to be configured";
    }

    @Override
    public final IllegalArgumentException providerUrlOrAuthServerUrlNeedsToBeConfigured() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.providerUrlOrAuthServerUrlNeedsToBeConfigured$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void loadedOpenIdProviderMetadata(String discoveryUrl) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.loadedOpenIdProviderMetadata$str(), (Object)discoveryUrl);
    }

    protected String loadedOpenIdProviderMetadata$str() {
        return "ELY23004: Loaded OpenID provider metadata from '%s'";
    }

    @Override
    public final void unableToLoadOpenIdProviderMetadata(String discoveryUrl) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.unableToLoadOpenIdProviderMetadata$str(), (Object)discoveryUrl);
    }

    protected String unableToLoadOpenIdProviderMetadata$str() {
        return "ELY23005: Unable to load OpenID provider metadata from %s";
    }

    protected String failedToDecodeRequestUri$str() {
        return "ELY23006: Failed to decode request URI";
    }

    @Override
    public final RuntimeException failedToDecodeRequestUri(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToDecodeRequestUri$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToWriteToResponseOutputStream$str() {
        return "ELY23007: Failed to write to response output stream";
    }

    @Override
    public final RuntimeException failedToWriteToResponseOutputStream(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToWriteToResponseOutputStream$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToParseToken$str() {
        return "ELY23008: Unable to parse token";
    }

    @Override
    public final IllegalArgumentException unableToParseToken() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToParseToken$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String oidcConfigFileNotFound$str() {
        return "ELY23009: OIDC client configuration file not found";
    }

    @Override
    public final RuntimeException oidcConfigFileNotFound(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.oidcConfigFileNotFound$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToInvokeRemoteLogout(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToInvokeRemoteLogout$str(), new Object[0]);
    }

    protected String failedToInvokeRemoteLogout$str() {
        return "ELY23010: Failed to invoke remote logout";
    }

    @Override
    public final void refreshTokenFailure(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.refreshTokenFailure$str(), new Object[0]);
    }

    protected String refreshTokenFailure$str() {
        return "ELY23011: Refresh token failure";
    }

    @Override
    public final void refreshTokenFailureStatus(int status, String error) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.refreshTokenFailureStatus$str(), (Object)status, (Object)error);
    }

    protected String refreshTokenFailureStatus$str() {
        return "ELY23012: Refresh token failure status: %d %s";
    }

    @Override
    public final void failedVerificationOfToken(String error) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.failedVerificationOfToken$str(), (Object)error);
    }

    protected String failedVerificationOfToken$str() {
        return "ELY23013: Failed verification of token: %s";
    }

    @Override
    public final void failedToRefreshTokenWithALongerTTLThanMin() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.failedToRefreshTokenWithALongerTTLThanMin$str(), new Object[0]);
    }

    protected String failedToRefreshTokenWithALongerTTLThanMin$str() {
        return "ELY23014: Failed to refresh the token with a longer time-to-live than the minimum";
    }

    protected String noExpectedIssuerGiven$str() {
        return "ELY23015: No expected issuer given";
    }

    @Override
    public final IllegalArgumentException noExpectedIssuerGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noExpectedIssuerGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noClientIDGiven$str() {
        return "ELY23016: No client ID given";
    }

    @Override
    public final IllegalArgumentException noClientIDGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noClientIDGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noExpectedJwsAlgorithmGiven$str() {
        return "ELY23017: No expected JWS algorithm given";
    }

    @Override
    public final IllegalArgumentException noExpectedJwsAlgorithmGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noExpectedJwsAlgorithmGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noJwksPublicKeyOrClientSecretKeyGiven$str() {
        return "ELY23018: No JWKS public key or client secret key given";
    }

    @Override
    public final IllegalArgumentException noJwksPublicKeyOrClientSecretKeyGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noJwksPublicKeyOrClientSecretKeyGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIDToken$str() {
        return "ELY23019: Invalid ID token";
    }

    @Override
    public final OidcException invalidIDToken(Throwable cause) {
        OidcException result = new OidcException(String.format(this.getLoggingLocale(), this.invalidIDToken$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedValueForIssuedForClaim$str() {
        return "Unexpected value for azp (issued for) claim";
    }

    @Override
    public final String unexpectedValueForIssuedForClaim() {
        return String.format(this.getLoggingLocale(), this.unexpectedValueForIssuedForClaim$str(), new Object[0]);
    }

    protected String invalidTokenClaimValue$str() {
        return "ELY23020: Invalid token claim value";
    }

    @Override
    public final IllegalArgumentException invalidTokenClaimValue() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidTokenClaimValue$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIDTokenClaims$str() {
        return "ELY23021: Invalid ID token claims";
    }

    @Override
    public final OidcException invalidIDTokenClaims() {
        OidcException result = new OidcException(String.format(this.getLoggingLocale(), this.invalidIDTokenClaims$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keycloakRealmMissing$str() {
        return "ELY23022: Must set 'realm' in config";
    }

    @Override
    public final RuntimeException keycloakRealmMissing() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.keycloakRealmMissing$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String resourceOrClientIdMustBeSet$str() {
        return "ELY23023: Must set 'resource' or 'client-id'";
    }

    @Override
    public final RuntimeException resourceOrClientIdMustBeSet() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.resourceOrClientIdMustBeSet$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidConfigurationForBearerAuth$str() {
        return "ELY23024: For bearer auth, you must set the 'realm-public-key' or one of 'auth-server-url' and 'provider-url'";
    }

    @Override
    public final IllegalArgumentException invalidConfigurationForBearerAuth() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidConfigurationForBearerAuth$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String authServerUrlOrProviderUrlMustBeSet$str() {
        return "ELY23025: Must set 'auth-server-url' or 'provider-url'";
    }

    @Override
    public final RuntimeException authServerUrlOrProviderUrlMustBeSet() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.authServerUrlOrProviderUrlMustBeSet$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void noClientSecretConfigured(String clientId) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.noClientSecretConfigured$str(), (Object)clientId);
    }

    protected String noClientSecretConfigured$str() {
        return "ELY23026: Client '%s' does not have a secret configured";
    }

    protected String unsupportedPublicKey$str() {
        return "ELY23027: Unsupported public key";
    }

    @Override
    public final IllegalArgumentException unsupportedPublicKey() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedPublicKey$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateSignedToken$str() {
        return "ELY23028: Unable to create signed token";
    }

    @Override
    public final IllegalArgumentException unableToCreateSignedToken() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToCreateSignedToken$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidJwtClientCredentialsConfig$str() {
        return "ELY23029: Configuration of jwt credentials is missing or incorrect for client '%s'";
    }

    @Override
    public final RuntimeException invalidJwtClientCredentialsConfig(String clientId) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.invalidJwtClientCredentialsConfig$str(), clientId));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingParameterInJwtClientCredentialsConfig$str() {
        return "ELY23030: Missing parameter '%s' in jwt credentials for client %s";
    }

    @Override
    public final RuntimeException missingParameterInJwtClientCredentialsConfig(String parameter, String clientId) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.missingParameterInJwtClientCredentialsConfig$str(), parameter, clientId));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToParseKeyWithValue$str() {
        return "ELY23031: Unable to parse key '%s' with value '%s'";
    }

    @Override
    public final IllegalArgumentException unableToParseKeyWithValue(String key, Object value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToParseKeyWithValue$str(), key, value));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadKeyWithAlias$str() {
        return "ELY23032: Unable to load key with alias '%s' from keystore";
    }

    @Override
    public final RuntimeException unableToLoadKeyWithAlias(String alias) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToLoadKeyWithAlias$str(), alias));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadPrivateKey$str() {
        return "ELY23033: Unable to load private key from keystore";
    }

    @Override
    public final RuntimeException unableToLoadPrivateKey(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToLoadPrivateKey$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToFindKeystoreFile$str() {
        return "ELY23034: Unable to find keystore file '%s'";
    }

    @Override
    public final RuntimeException unableToFindKeystoreFile(String keystoreFile) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToFindKeystoreFile$str(), keystoreFile));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidJwtClientCredentialsUsingSecretConfig$str() {
        return "ELY23035: Configuration of secret jwt client credentials is missing or incorrect for client '%s'";
    }

    @Override
    public final RuntimeException invalidJwtClientCredentialsUsingSecretConfig(String clientId) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.invalidJwtClientCredentialsUsingSecretConfig$str(), clientId));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAlgorithmInJwtClientCredentialsConfig$str() {
        return "ELY23036: Invalid value for 'algorithm' in secret jwt client credentials configuration for client '%s'";
    }

    @Override
    public final RuntimeException invalidAlgorithmInJwtClientCredentialsConfig(String clientId) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.invalidAlgorithmInJwtClientCredentialsConfig$str(), clientId));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToDetermineClientCredentialsProviderType$str() {
        return "ELY23037: Unable to determine client credentials provider type for client '%s'";
    }

    @Override
    public final RuntimeException unableToDetermineClientCredentialsProviderType(String clientId) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToDetermineClientCredentialsProviderType$str(), clientId));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToFindClientCredentialsProvider$str() {
        return "ELY23038: Unable to find client credentials provider '%s'";
    }

    @Override
    public final RuntimeException unableToFindClientCredentialsProvider(String provider) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToFindClientCredentialsProvider$str(), provider));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadKeyStore$str() {
        return "ELY23039: Unable to load keystore";
    }

    @Override
    public final RuntimeException unableToLoadKeyStore(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToLoadKeyStore$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadTrustStore$str() {
        return "ELY23040: Unable to load truststore";
    }

    @Override
    public final RuntimeException unableToLoadTrustStore(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToLoadTrustStore$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToFindTrustStoreFile$str() {
        return "ELY23041: Unable to find truststore file '%s'";
    }

    @Override
    public final RuntimeException unableToFindTrustStoreFile(String trustStoreFile) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToFindTrustStoreFile$str(), trustStoreFile));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedValueForAtHashClaim$str() {
        return "ELY23042: Unexpected value for at_hash claim";
    }

    @Override
    public final String unexpectedValueForAtHashClaim() {
        return String.format(this.getLoggingLocale(), this.unexpectedValueForAtHashClaim$str(), new Object[0]);
    }

    protected String unknownAlgorithm$str() {
        return "ELY23043: Uknown algorithm: '%s'";
    }

    @Override
    public final IllegalArgumentException unknownAlgorithm(String algorithm) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToParseTokenFromCookie(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToParseTokenFromCookie$str(), new Object[0]);
    }

    protected String failedToParseTokenFromCookie$str() {
        return "ELY23044: Failed to parse token from cookie";
    }

    protected String unableToCreateRedirectResponse$str() {
        return "ELY23045: Unable to create redirect response";
    }

    @Override
    public final IllegalArgumentException unableToCreateRedirectResponse(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToCreateRedirectResponse$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToSetAuthServerUrl$str() {
        return "ELY23046: Unable to set auth server URL";
    }

    @Override
    public final RuntimeException unableToSetAuthServerUrl(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToSetAuthServerUrl$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToResolveARelativeUrl$str() {
        return "ELY23047: Unable resolve a relative URL";
    }

    @Override
    public final RuntimeException unableToResolveARelativeUrl() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToResolveARelativeUrl$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidUri$str() {
        return "ELY23048: Invalid URI: '%s'";
    }

    @Override
    public final RuntimeException invalidUri(String uri) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.invalidUri$str(), uri));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void invalidAuthServerUrlOrProviderUrl(String url) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.invalidAuthServerUrlOrProviderUrl$str(), (Object)url);
    }

    protected String invalidAuthServerUrlOrProviderUrl$str() {
        return "ELY23049: Invalid 'auth-server-url' or 'provider-url': '%s'";
    }

    protected String invalidBearerTokenClaims$str() {
        return "ELY23050: Invalid bearer token claims";
    }

    @Override
    public final OidcException invalidBearerTokenClaims() {
        OidcException result = new OidcException(String.format(this.getLoggingLocale(), this.invalidBearerTokenClaims$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidBearerToken$str() {
        return "ELY23051: Invalid bearer token";
    }

    @Override
    public final OidcException invalidBearerToken(Throwable cause) {
        OidcException result = new OidcException(String.format(this.getLoggingLocale(), this.invalidBearerToken$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void noTrustedCertificatesInToken() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.noTrustedCertificatesInToken$str(), new Object[0]);
    }

    protected String noTrustedCertificatesInToken$str() {
        return "ELY23052: No trusted certificates in token";
    }

    @Override
    public final void noPeerCertificatesEstablishedOnConnection() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.noPeerCertificatesEstablishedOnConnection$str(), new Object[0]);
    }

    protected String noPeerCertificatesEstablishedOnConnection$str() {
        return "ELY23053: No peer certificates established on the connection";
    }

    protected String unexpectedValueForTypeClaim$str() {
        return "ELY23054: Unexpected value for typ claim";
    }

    @Override
    public final String unexpectedValueForTypeClaim() {
        return String.format(this.getLoggingLocale(), this.unexpectedValueForTypeClaim$str(), new Object[0]);
    }

    protected String unableToObtainToken$str() {
        return "ELY23055: Unable to obtain token: %d";
    }

    @Override
    public final IOException unableToObtainToken(int status) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unableToObtainToken$str(), status));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noMessageEntity$str() {
        return "ELY23056: No message entity";
    }

    @Override
    public final IOException noMessageEntity() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.noMessageEntity$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

