/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.util.concurrent.CompletableFuture;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.batch.BatchContainer;
import org.infinispan.cache.impl.ContextBuilder;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class InvocationHelper {
    private static final Log log = LogFactory.getLog(InvocationHelper.class);
    @Inject
    protected AsyncInterceptorChain invoker;
    @Inject
    protected InvocationContextFactory invocationContextFactory;
    @Inject
    protected TransactionManager transactionManager;
    @Inject
    protected Configuration config;
    @Inject
    protected BatchContainer batchContainer;
    @Inject
    protected BlockingManager blockingManager;
    private final ContextBuilder defaultBuilder = i -> this.createInvocationContextWithImplicitTransaction(i, false);

    private static void checkLockOwner(InvocationContext context, VisitableCommand command) {
        if (context.getLockOwner() == null && command instanceof RemoteLockCommand) {
            context.setLockOwner(((RemoteLockCommand)((Object)command)).getKeyLockOwner());
        }
    }

    private static boolean isTxInjected(InvocationContext ctx) {
        return ctx.isInTxScope() && ((TxInvocationContext)ctx).isImplicitTransaction();
    }

    public <T> T invoke(VisitableCommand command, int keyCount) {
        InvocationContext ctx = this.createInvocationContextWithImplicitTransaction(keyCount, false);
        return this.invoke(ctx, command);
    }

    public <T> T invoke(ContextBuilder builder, VisitableCommand command, int keyCount) {
        InvocationContext ctx = builder.create(keyCount);
        return this.invoke(ctx, command);
    }

    public <T> T invoke(InvocationContext context, VisitableCommand command) {
        InvocationHelper.checkLockOwner(context, command);
        return InvocationHelper.isTxInjected(context) ? this.executeCommandWithInjectedTx(context, command) : this.doInvoke(context, command);
    }

    public <T> CompletableFuture<T> invokeAsync(VisitableCommand command, int keyCount) {
        InvocationContext ctx = this.createInvocationContextWithImplicitTransaction(keyCount, false);
        return this.invokeAsync(ctx, command);
    }

    public <T> CompletableFuture<T> invokeAsync(ContextBuilder builder, VisitableCommand command, int keyCount) {
        InvocationContext ctx = builder.create(keyCount);
        return this.invokeAsync(ctx, command);
    }

    public <T> CompletableFuture<T> invokeAsync(InvocationContext context, VisitableCommand command) {
        InvocationHelper.checkLockOwner(context, command);
        return InvocationHelper.isTxInjected(context) ? this.executeCommandAsyncWithInjectedTx(context, command) : this.doInvokeAsync(context, command);
    }

    public ContextBuilder defaultContextBuilderForWrite() {
        return this.defaultBuilder;
    }

    public InvocationContext createInvocationContextWithImplicitTransaction(int keyCount, boolean forceCreateTransaction) {
        boolean txInjected = false;
        TransactionConfiguration txConfig = this.config.transaction();
        if (txConfig.transactionMode().isTransactional()) {
            Transaction transaction = this.getOngoingTransaction();
            if (transaction == null && (forceCreateTransaction || txConfig.autoCommit())) {
                transaction = this.tryBegin();
                txInjected = true;
            }
            return this.invocationContextFactory.createInvocationContext(transaction, txInjected);
        }
        return this.invocationContextFactory.createInvocationContext(true, keyCount);
    }

    public String toString() {
        return "InvocationHelper{}";
    }

    private Transaction getOngoingTransaction() {
        try {
            Transaction transaction = null;
            if (this.transactionManager != null && (transaction = this.transactionManager.getTransaction()) == null && this.config.invocationBatching().enabled()) {
                transaction = this.batchContainer.getBatchTransaction();
            }
            return transaction;
        }
        catch (SystemException e) {
            throw new CacheException("Unable to get transaction", (Throwable)e);
        }
    }

    private <T> T executeCommandWithInjectedTx(InvocationContext ctx, VisitableCommand command) {
        T result;
        try {
            result = this.doInvoke(ctx, command);
        }
        catch (Throwable e) {
            this.tryRollback();
            throw e;
        }
        this.tryCommit();
        return result;
    }

    private <T> CompletableFuture<T> executeCommandAsyncWithInjectedTx(InvocationContext ctx, VisitableCommand command) {
        CompletableFuture<T> cf;
        Transaction implicitTransaction;
        try {
            implicitTransaction = this.transactionManager.suspend();
            assert (implicitTransaction != null);
            cf = this.doInvokeAsync(ctx, command);
        }
        catch (SystemException e) {
            throw new CacheException("Cannot suspend implicit transaction", (Throwable)e);
        }
        catch (Throwable e) {
            this.tryRollback();
            throw e;
        }
        return this.blockingManager.handleBlocking(cf, (result, throwable) -> {
            if (throwable != null) {
                try {
                    implicitTransaction.rollback();
                }
                catch (SystemException e) {
                    log.trace("Could not rollback", e);
                    throwable.addSuppressed(e);
                }
                throw CompletableFutures.asCompletionException(throwable);
            }
            try {
                implicitTransaction.commit();
            }
            catch (Exception e) {
                log.couldNotCompleteInjectedTransaction(e);
                throw CompletableFutures.asCompletionException(e);
            }
            return result;
        }, ctx.getLockOwner()).toCompletableFuture();
    }

    private Transaction tryBegin() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            this.transactionManager.begin();
            Transaction transaction = this.getOngoingTransaction();
            if (log.isTraceEnabled()) {
                log.tracef("Implicit transaction started! Transaction: %s", transaction);
            }
            return transaction;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException("Unable to begin implicit transaction.", (Throwable)e);
        }
    }

    private void tryRollback() {
        block3: {
            try {
                if (this.transactionManager != null) {
                    this.transactionManager.rollback();
                }
            }
            catch (Throwable t) {
                if (!log.isTraceEnabled()) break block3;
                log.trace("Could not rollback", t);
            }
        }
    }

    private void tryCommit() {
        if (this.transactionManager == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Committing transaction as it was implicit: %s", this.getOngoingTransaction());
        }
        try {
            this.transactionManager.commit();
        }
        catch (Throwable e) {
            log.couldNotCompleteInjectedTransaction(e);
            throw new CacheException("Could not commit implicit transaction", e);
        }
    }

    private <T> CompletableFuture<T> doInvokeAsync(InvocationContext ctx, VisitableCommand command) {
        return this.invoker.invokeAsync(ctx, command);
    }

    private <T> T doInvoke(InvocationContext ctx, VisitableCommand command) {
        return (T)this.invoker.invoke(ctx, command);
    }
}

