/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal.formatting;

import java.io.PrintStream;
import org.aesh.readline.terminal.formatting.Color;

public class TerminalColor {
    private Color textColor = Color.DEFAULT;
    private int intTextColor = -1;
    private Color backgroundColor = Color.DEFAULT;
    private int intBackgroundColor = -1;
    private int length = -1;
    private String cache;
    private Color.Intensity intensity = Color.Intensity.NORMAL;

    public TerminalColor() {
    }

    public TerminalColor(Color text, Color background) {
        if (text != null) {
            this.textColor = text;
        }
        if (background != null) {
            this.backgroundColor = background;
        }
    }

    public TerminalColor(Color textColor, Color background, Color.Intensity intensity) {
        this(textColor, background);
        this.intensity = intensity;
    }

    public TerminalColor(int text, int background) {
        this.intTextColor = text;
        this.intBackgroundColor = background;
    }

    public TerminalColor(int text, Color background) {
        this.intTextColor = text;
        this.backgroundColor = background;
    }

    public TerminalColor(int text, Color background, Color.Intensity intensity) {
        this.intTextColor = text;
        this.backgroundColor = background;
        this.intensity = intensity;
    }

    public TerminalColor(Color text, int background) {
        this.textColor = text;
        this.intBackgroundColor = background;
    }

    public TerminalColor(Color text, int background, Color.Intensity intensity) {
        this.textColor = text;
        this.intBackgroundColor = background;
        this.intensity = intensity;
    }

    public boolean isFormatted() {
        return this.textColor != Color.DEFAULT || this.backgroundColor != Color.DEFAULT || this.intensity != Color.Intensity.NORMAL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TerminalColor)) {
            return false;
        }
        TerminalColor that = (TerminalColor)o;
        return this.intBackgroundColor == that.intBackgroundColor && this.intTextColor == that.intTextColor && this.backgroundColor == that.backgroundColor && this.intensity == that.intensity && this.textColor == that.textColor;
    }

    public int hashCode() {
        int result = this.textColor.hashCode();
        result = 31 * result + this.intTextColor;
        result = 31 * result + this.backgroundColor.hashCode();
        result = 31 * result + this.intBackgroundColor;
        result = 31 * result + this.intensity.hashCode();
        return result;
    }

    public String fullString() {
        return "\u001b[" + this.toString() + "m";
    }

    public String toString() {
        if (this.cache != null) {
            return this.cache;
        }
        StringBuilder builder = new StringBuilder();
        if (this.intTextColor > -1) {
            builder.append(38).append(';').append(5).append(';').append(this.intTextColor);
        } else {
            builder.append(this.intensity.getValue(Color.Type.FOREGROUND)).append(this.textColor.getValue());
        }
        builder.append(';');
        if (this.intBackgroundColor > -1) {
            builder.append(48).append(';').append(5).append(';').append(this.intBackgroundColor);
        } else {
            builder.append(this.intensity.getValue(Color.Type.BACKGROUND)).append(this.backgroundColor.getValue());
        }
        this.cache = builder.toString();
        this.length = this.cache.length();
        return this.cache;
    }

    public int getLength() {
        if (this.length < 0) {
            this.toString();
        }
        return this.length;
    }

    public void write(PrintStream out) {
        out.print(this.toString());
    }

    public String toString(TerminalColor prev) {
        if (this.equals(prev)) {
            return "";
        }
        String txt = this.textString(prev);
        String bg = this.backgroundString(prev);
        if (txt.length() > 0 && bg.length() > 0) {
            return this.textString(prev) + ';' + this.backgroundString(prev);
        }
        return this.textString(prev) + this.backgroundString(prev);
    }

    private String backgroundString(TerminalColor prev) {
        StringBuilder builder = new StringBuilder();
        if (prev.intBackgroundColor != this.intBackgroundColor || prev.backgroundColor != this.backgroundColor || prev.intensity != this.intensity) {
            if (prev.intBackgroundColor > -1 || this.intBackgroundColor > -1) {
                if (prev.intBackgroundColor == this.intBackgroundColor) {
                    builder.append("");
                }
                if (prev.intBackgroundColor != this.intBackgroundColor && this.intBackgroundColor > -1) {
                    builder.append(38).append(';').append(5).append(';').append(this.intBackgroundColor);
                } else {
                    builder.append(this.intensity.getValue(Color.Type.BACKGROUND)).append(this.backgroundColor.getValue());
                }
            } else if (prev.backgroundColor != this.backgroundColor) {
                builder.append(this.intensity.getValue(Color.Type.BACKGROUND)).append(this.backgroundColor.getValue());
            }
        }
        return builder.toString();
    }

    private String textString(TerminalColor prev) {
        StringBuilder builder = new StringBuilder();
        if (prev.intTextColor != this.intTextColor || prev.textColor != this.textColor || prev.intensity != this.intensity) {
            if (prev.intTextColor > -1 || this.intTextColor > -1) {
                if (prev.intTextColor == this.intTextColor) {
                    builder.append("");
                }
                if (prev.intTextColor != this.intTextColor && this.intTextColor > -1) {
                    builder.append(38).append(';').append(5).append(';').append(this.intTextColor);
                } else {
                    builder.append(this.intensity.getValue(Color.Type.FOREGROUND)).append(this.textColor.getValue());
                }
            } else if (prev.textColor != this.textColor) {
                builder.append(this.intensity.getValue(Color.Type.FOREGROUND)).append(this.textColor.getValue());
            }
        }
        return builder.toString();
    }
}

