/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.clustering.controller.FunctionExecutorRegistry;
import org.jboss.as.clustering.controller.RuntimeResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelRuntimeResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolMetricsHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jgroups.JChannel;
import org.jgroups.stack.Protocol;

public class ForkProtocolRuntimeResourceRegistration
implements RuntimeResourceRegistration {
    private final FunctionExecutorRegistry<JChannel> executors;

    public ForkProtocolRuntimeResourceRegistration(FunctionExecutorRegistry<JChannel> executors) {
        this.executors = executors;
    }

    public void register(OperationContext context) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ManagementResourceRegistration registration = context.getResourceRegistrationForUpdate();
        String protocolName = context.getCurrentAddressValue();
        String moduleName = AbstractProtocolResourceDefinition.Attribute.MODULE.resolveModelAttribute((ExpressionResolver)context, resource.getModel()).asString();
        Class<? extends Protocol> protocolClass = ChannelRuntimeResourceRegistration.findProtocolClass(context, protocolName, moduleName);
        final Map<String, ProtocolMetricsHandler.Attribute> attributes = ProtocolMetricsHandler.findProtocolAttributes(protocolClass);
        if (registration.getPathAddress().getLastElement().isWildcard()) {
            OverrideDescriptionProvider provider = new OverrideDescriptionProvider(){

                public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                    HashMap<String, ModelNode> result = new HashMap<String, ModelNode>();
                    for (ProtocolMetricsHandler.Attribute attribute : attributes.values()) {
                        ModelNode value = new ModelNode();
                        value.get("description").set(attribute.getDescription());
                        result.put(attribute.getName(), value);
                    }
                    return result;
                }

                public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                    return Collections.emptyMap();
                }
            };
            registration = registration.registerOverrideModel(protocolName, provider);
        }
        ProtocolMetricsHandler handler = new ProtocolMetricsHandler(this.executors);
        for (ProtocolMetricsHandler.Attribute attribute : attributes.values()) {
            String name = attribute.getName();
            ProtocolMetricsHandler.FieldType type = ProtocolMetricsHandler.FieldType.valueOf(attribute.getType());
            registration.registerMetric((AttributeDefinition)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type.getModelType()).setStorageRuntime()).build(), (OperationStepHandler)handler);
        }
    }

    public void unregister(OperationContext context) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ManagementResourceRegistration registration = context.getResourceRegistrationForUpdate();
        String protocolName = context.getCurrentAddressValue();
        String moduleName = AbstractProtocolResourceDefinition.Attribute.MODULE.resolveModelAttribute((ExpressionResolver)context, resource.getModel()).asString();
        Class<? extends Protocol> protocolClass = ChannelRuntimeResourceRegistration.findProtocolClass(context, protocolName, moduleName);
        for (String attribute : ProtocolMetricsHandler.findProtocolAttributes(protocolClass).keySet()) {
            registration.unregisterAttribute(attribute);
        }
    }
}

