/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config.smallrye;

import io.smallrye.config.PropertiesConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.config.smallrye.Registry;
import org.wildfly.extension.microprofile.config.smallrye.ServiceNames;

public class PropertiesConfigSourceRegistrationService
implements Service {
    private final String name;
    private final PropertiesConfigSource configSource;
    private final Registry<ConfigSource> sources;

    PropertiesConfigSourceRegistrationService(String name, PropertiesConfigSource configSource, Registry<ConfigSource> sources) {
        this.name = name;
        this.configSource = configSource;
        this.sources = sources;
    }

    static void install(OperationContext context, String name, PropertiesConfigSource configSource, Registry registry) {
        context.getServiceTarget().addService(ServiceNames.CONFIG_SOURCE.append(new String[]{name})).setInstance((Service)new PropertiesConfigSourceRegistrationService(name, configSource, registry)).install();
    }

    public void start(StartContext startContext) {
        this.sources.register(this.name, (ConfigSource)this.configSource);
    }

    public void stop(StopContext context) {
        this.sources.unregister(this.name);
    }
}

