/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.auth.realm.ldap.CredentialLoader;
import org.wildfly.security.auth.realm.ldap.CredentialPersister;
import org.wildfly.security.auth.realm.ldap.DirectEvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.ElytronMessages;
import org.wildfly.security.auth.realm.ldap.EvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealm;
import org.wildfly.security.auth.realm.ldap.OtpCredentialLoader;
import org.wildfly.security.auth.realm.ldap.UserPasswordCredentialLoader;
import org.wildfly.security.auth.realm.ldap.X509EvidenceVerifier;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.password.spec.Encoding;
import org.wildfly.security.provider.util.ProviderUtil;

public class LdapSecurityRealmBuilder {
    private static final int DEFAULT_SEARCH_TIME_LIMIT = 10000;
    private boolean built = false;
    private Supplier<Provider[]> providers = ProviderUtil.INSTALLED_PROVIDERS;
    private ExceptionSupplier<DirContext, NamingException> dirContextSupplier;
    private NameRewriter nameRewriter = NameRewriter.IDENTITY_REWRITER;
    private LdapSecurityRealm.IdentityMapping identityMapping;
    private int pageSize = 50;
    private List<CredentialLoader> credentialLoaders = new ArrayList<CredentialLoader>();
    private List<CredentialPersister> credentialPersisters = new ArrayList<CredentialPersister>();
    private List<EvidenceVerifier> evidenceVerifiers = new ArrayList<EvidenceVerifier>();
    private Charset hashCharset = StandardCharsets.UTF_8;
    private Encoding hashEncoding = Encoding.BASE64;

    private LdapSecurityRealmBuilder() {
    }

    public static LdapSecurityRealmBuilder builder() {
        return new LdapSecurityRealmBuilder();
    }

    public LdapSecurityRealmBuilder setProviders(Supplier<Provider[]> providers) {
        this.assertNotBuilt();
        this.providers = providers;
        return this;
    }

    public LdapSecurityRealmBuilder setDirContextSupplier(ExceptionSupplier<DirContext, NamingException> dirContextSupplier) {
        this.assertNotBuilt();
        this.dirContextSupplier = dirContextSupplier;
        return this;
    }

    public LdapSecurityRealmBuilder setNameRewriter(NameRewriter nameRewriter) {
        Assert.checkNotNullParam("nameRewriter", nameRewriter);
        this.assertNotBuilt();
        this.nameRewriter = nameRewriter;
        return this;
    }

    public LdapSecurityRealmBuilder setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public IdentityMappingBuilder identityMapping() {
        this.assertNotBuilt();
        return new IdentityMappingBuilder();
    }

    LdapSecurityRealmBuilder setIdentityMapping(LdapSecurityRealm.IdentityMapping principalMapping) {
        this.identityMapping = principalMapping;
        return this;
    }

    public LdapSecurityRealmBuilder setHashCharset(Charset hashCharset) {
        Assert.assertNotNull(hashCharset);
        this.hashCharset = hashCharset;
        return this;
    }

    public LdapSecurityRealmBuilder setHashEncoding(Encoding hashEncoding) {
        Assert.assertNotNull(hashEncoding);
        this.hashEncoding = hashEncoding;
        return this;
    }

    public UserPasswordCredentialLoaderBuilder userPasswordCredentialLoader() {
        this.assertNotBuilt();
        return new UserPasswordCredentialLoaderBuilder();
    }

    public OtpCredentialLoaderBuilder otpCredentialLoader() {
        this.assertNotBuilt();
        return new OtpCredentialLoaderBuilder();
    }

    public X509EvidenceVerifierBuilder x509EvidenceVerifier() {
        this.assertNotBuilt();
        return new X509EvidenceVerifierBuilder();
    }

    LdapSecurityRealmBuilder addCredentialLoader(CredentialLoader credentialLoader) {
        this.credentialLoaders.add(credentialLoader);
        return this;
    }

    LdapSecurityRealmBuilder addCredentialPersister(CredentialPersister credentialPersister) {
        this.credentialPersisters.add(credentialPersister);
        return this;
    }

    LdapSecurityRealmBuilder addEvidenceVerifier(EvidenceVerifier evidenceVerifier) {
        this.evidenceVerifiers.add(evidenceVerifier);
        return this;
    }

    public LdapSecurityRealmBuilder addDirectEvidenceVerification() {
        return this.addDirectEvidenceVerification(false);
    }

    public LdapSecurityRealmBuilder addDirectEvidenceVerification(boolean allowBlankPassword) {
        this.assertNotBuilt();
        return this.addEvidenceVerifier(new DirectEvidenceVerifier(allowBlankPassword));
    }

    public ModifiableSecurityRealm build() {
        this.assertNotBuilt();
        if (this.dirContextSupplier == null) {
            throw ElytronMessages.log.noDirContextSupplierSet();
        }
        if (this.identityMapping == null) {
            throw ElytronMessages.log.noPrincipalMappingDefinition();
        }
        this.built = true;
        return new LdapSecurityRealm(this.providers, this.dirContextSupplier, this.nameRewriter, this.identityMapping, this.credentialLoaders, this.credentialPersisters, this.evidenceVerifiers, this.pageSize, this.hashCharset, this.hashEncoding);
    }

    private void assertNotBuilt() {
        if (this.built) {
            throw ElytronMessages.log.builderAlreadyBuilt();
        }
    }

    public class X509EvidenceVerifierBuilder {
        private boolean built = false;
        private List<X509EvidenceVerifier.CertificateVerifier> certificateVerifiers = new ArrayList<X509EvidenceVerifier.CertificateVerifier>();

        public X509EvidenceVerifierBuilder addSerialNumberCertificateVerifier(String ldapAttribute) {
            this.assertNotBuilt();
            this.certificateVerifiers.add(new X509EvidenceVerifier.SerialNumberCertificateVerifier(ldapAttribute));
            return this;
        }

        public X509EvidenceVerifierBuilder addSubjectDnCertificateVerifier(String ldapAttribute) {
            this.assertNotBuilt();
            this.certificateVerifiers.add(new X509EvidenceVerifier.SubjectDnCertificateVerifier(ldapAttribute));
            return this;
        }

        public X509EvidenceVerifierBuilder addDigestCertificateVerifier(String ldapAttribute, String algorithm) {
            this.assertNotBuilt();
            this.certificateVerifiers.add(new X509EvidenceVerifier.DigestCertificateVerifier(ldapAttribute, algorithm));
            return this;
        }

        public X509EvidenceVerifierBuilder addEncodedCertificateVerifier(String ldapAttribute) {
            this.assertNotBuilt();
            this.certificateVerifiers.add(new X509EvidenceVerifier.EncodedCertificateVerifier(ldapAttribute));
            return this;
        }

        public LdapSecurityRealmBuilder build() {
            this.assertNotBuilt();
            Assert.checkNotEmptyParam("certificateVerifiers", this.certificateVerifiers);
            this.built = true;
            LdapSecurityRealmBuilder.this.addEvidenceVerifier(new X509EvidenceVerifier(this.certificateVerifiers));
            return LdapSecurityRealmBuilder.this;
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
            LdapSecurityRealmBuilder.this.assertNotBuilt();
        }
    }

    public class OtpCredentialLoaderBuilder {
        private boolean built = false;
        private String otpAlgorithmAttribute = null;
        private String otpHashAttribute = null;
        private String otpSeedAttribute = null;
        private String otpSequenceAttribute = null;

        public OtpCredentialLoaderBuilder setOtpAlgorithmAttribute(String otpAlgorithmAttribute) {
            this.assertNotBuilt();
            this.otpAlgorithmAttribute = otpAlgorithmAttribute;
            return this;
        }

        public OtpCredentialLoaderBuilder setOtpHashAttribute(String otpHashAttribute) {
            this.assertNotBuilt();
            this.otpHashAttribute = otpHashAttribute;
            return this;
        }

        public OtpCredentialLoaderBuilder setOtpSeedAttribute(String otpSeedAttribute) {
            this.assertNotBuilt();
            this.otpSeedAttribute = otpSeedAttribute;
            return this;
        }

        public OtpCredentialLoaderBuilder setOtpSequenceAttribute(String otpSequenceAttribute) {
            this.assertNotBuilt();
            this.otpSequenceAttribute = otpSequenceAttribute;
            return this;
        }

        public LdapSecurityRealmBuilder build() {
            this.assertNotBuilt();
            this.built = true;
            OtpCredentialLoader ocl = new OtpCredentialLoader(this.otpAlgorithmAttribute, this.otpHashAttribute, this.otpSeedAttribute, this.otpSequenceAttribute);
            LdapSecurityRealmBuilder.this.addCredentialLoader(ocl);
            LdapSecurityRealmBuilder.this.addCredentialPersister(ocl);
            return LdapSecurityRealmBuilder.this;
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
            LdapSecurityRealmBuilder.this.assertNotBuilt();
        }
    }

    public class UserPasswordCredentialLoaderBuilder {
        private boolean built = false;
        private String userPasswordAttribute = "userPassword";
        private boolean enablePersistence = false;
        private boolean enableVerification = true;

        public UserPasswordCredentialLoaderBuilder setUserPasswordAttribute(String userPasswordAttribute) {
            this.assertNotBuilt();
            this.userPasswordAttribute = userPasswordAttribute;
            return this;
        }

        public UserPasswordCredentialLoaderBuilder enablePersistence() {
            this.assertNotBuilt();
            this.enablePersistence = true;
            return this;
        }

        public UserPasswordCredentialLoaderBuilder disableVerification() {
            this.assertNotBuilt();
            this.enableVerification = false;
            return this;
        }

        public LdapSecurityRealmBuilder build() {
            this.assertNotBuilt();
            this.built = true;
            UserPasswordCredentialLoader upcl = new UserPasswordCredentialLoader(this.userPasswordAttribute);
            LdapSecurityRealmBuilder.this.addCredentialLoader(upcl);
            if (this.enablePersistence) {
                LdapSecurityRealmBuilder.this.addCredentialPersister(upcl);
            }
            if (this.enableVerification) {
                LdapSecurityRealmBuilder.this.addEvidenceVerifier(upcl.toEvidenceVerifier());
            }
            return LdapSecurityRealmBuilder.this;
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
            LdapSecurityRealmBuilder.this.assertNotBuilt();
        }
    }

    public class IdentityMappingBuilder {
        private boolean built = false;
        private String searchDn = null;
        private boolean searchRecursive = false;
        private String nameAttribute;
        private int searchTimeLimit = 10000;
        private List<AttributeMapping> attributes = new ArrayList<AttributeMapping>();
        private LdapName newIdentityParent = null;
        private Attributes newIdentityAttributes = null;
        private String filterName;
        private String iteratorFilter;

        public IdentityMappingBuilder setSearchDn(String searchDn) {
            this.assertNotBuilt();
            this.searchDn = searchDn;
            return this;
        }

        public IdentityMappingBuilder searchRecursive() {
            this.assertNotBuilt();
            this.searchRecursive = true;
            return this;
        }

        public IdentityMappingBuilder setSearchTimeLimit(int limit) {
            this.assertNotBuilt();
            this.searchTimeLimit = limit;
            return this;
        }

        public IdentityMappingBuilder setRdnIdentifier(String nameAttribute) {
            this.assertNotBuilt();
            this.nameAttribute = nameAttribute;
            return this;
        }

        public IdentityMappingBuilder setNewIdentityParent(LdapName newIdentityParent) {
            this.assertNotBuilt();
            this.newIdentityParent = newIdentityParent;
            return this;
        }

        public IdentityMappingBuilder setNewIdentityAttributes(Attributes newIdentityAttributes) {
            this.assertNotBuilt();
            this.newIdentityAttributes = newIdentityAttributes;
            return this;
        }

        public IdentityMappingBuilder setFilterName(String filterName) {
            this.assertNotBuilt();
            this.filterName = filterName;
            return this;
        }

        public IdentityMappingBuilder setIteratorFilter(String iteratorFilter) {
            this.assertNotBuilt();
            this.iteratorFilter = iteratorFilter;
            return this;
        }

        public IdentityMappingBuilder map(AttributeMapping ... attributes) {
            this.assertNotBuilt();
            this.attributes.addAll(Arrays.asList(attributes));
            return this;
        }

        public LdapSecurityRealmBuilder build() {
            this.assertNotBuilt();
            this.built = true;
            if (this.filterName == null) {
                this.filterName = String.format("(%s={0})", this.nameAttribute);
            }
            return LdapSecurityRealmBuilder.this.setIdentityMapping(new LdapSecurityRealm.IdentityMapping(this.searchDn, this.searchRecursive, this.searchTimeLimit, this.nameAttribute, this.attributes, this.newIdentityParent, this.newIdentityAttributes, this.filterName, this.iteratorFilter));
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
            LdapSecurityRealmBuilder.this.assertNotBuilt();
        }
    }
}

