/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.LazyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.core.ContentSessionImpl;
import org.apache.jackrabbit.oak.core.MutableTree;
import org.apache.jackrabbit.oak.core.SecureNodeBuilder;
import org.apache.jackrabbit.oak.plugins.index.diffindex.UUIDDiffIndexProviderWrapper;
import org.apache.jackrabbit.oak.query.ExecutionContext;
import org.apache.jackrabbit.oak.query.QueryEngineImpl;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.PostValidationHook;
import org.apache.jackrabbit.oak.spi.commit.ResetCommitAttributeHook;
import org.apache.jackrabbit.oak.spi.commit.SimpleCommitContext;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionAware;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.PrefetchNodeStore;
import org.jetbrains.annotations.NotNull;

class MutableRoot
implements Root,
PermissionAware {
    private final NodeStore store;
    private final CommitHook hook;
    private final String workspaceName;
    private final Subject subject;
    private final SecurityProvider securityProvider;
    private final QueryEngineSettings queryEngineSettings;
    private final QueryIndexProvider indexProvider;
    private final ContentSessionImpl session;
    private final MutableTree rootTree;
    private final NodeBuilder builder;
    private final SecureNodeBuilder secureBuilder;
    private Move lastMove = new Move();
    private final MoveTracker moveTracker = new MoveTracker();
    private long modCount;
    private final LazyValue<PermissionProvider> permissionProvider = new LazyValue<PermissionProvider>(){

        protected PermissionProvider createValue() {
            return MutableRoot.this.getAcConfig().getPermissionProvider((Root)MutableRoot.this, MutableRoot.this.getContentSession().getWorkspaceName(), MutableRoot.this.subject.getPrincipals());
        }
    };

    MutableRoot(NodeStore store, CommitHook hook, String workspaceName, Subject subject, SecurityProvider securityProvider, QueryEngineSettings queryEngineSettings, QueryIndexProvider indexProvider, ContentSessionImpl session) {
        this.store = (NodeStore)Preconditions.checkNotNull((Object)store);
        this.hook = (CommitHook)Preconditions.checkNotNull((Object)hook);
        this.workspaceName = (String)Preconditions.checkNotNull((Object)workspaceName);
        this.subject = (Subject)Preconditions.checkNotNull((Object)subject);
        this.securityProvider = (SecurityProvider)Preconditions.checkNotNull((Object)securityProvider);
        this.queryEngineSettings = queryEngineSettings;
        this.indexProvider = indexProvider;
        this.session = (ContentSessionImpl)Preconditions.checkNotNull((Object)session);
        this.builder = store.getRoot().builder();
        this.secureBuilder = new SecureNodeBuilder(this.builder, this.permissionProvider);
        this.rootTree = new MutableTree(this, this.secureBuilder, this.lastMove);
    }

    void checkLive() {
        this.session.checkLive();
    }

    @NotNull
    public ContentSession getContentSession() {
        return this.session;
    }

    public boolean move(String sourcePath, String destPath) {
        if (PathUtils.isAncestor((String)((String)Preconditions.checkNotNull((Object)sourcePath)), (String)((String)Preconditions.checkNotNull((Object)destPath)))) {
            return false;
        }
        if (sourcePath.equals(destPath)) {
            return true;
        }
        this.checkLive();
        MutableTree source = this.rootTree.getTree(sourcePath);
        if (!source.exists()) {
            return false;
        }
        String newName = PathUtils.getName((String)destPath);
        MutableTree newParent = this.rootTree.getTree(PathUtils.getParentPath((String)destPath));
        if (!newParent.exists() || newParent.hasChild(newName)) {
            return false;
        }
        boolean success = source.moveTo(newParent, newName);
        if (success) {
            this.lastMove = this.lastMove.setMove(sourcePath, newParent, newName);
            this.updated();
            this.moveTracker.addMove(sourcePath, destPath);
        }
        return success;
    }

    @NotNull
    public MutableTree getTree(@NotNull String path) {
        this.checkLive();
        return this.rootTree.getTree(path);
    }

    public void rebase() {
        this.checkLive();
        this.store.rebase(this.builder);
        this.secureBuilder.baseChanged();
        if (this.permissionProvider.hasValue()) {
            ((PermissionProvider)this.permissionProvider.get()).refresh();
        }
    }

    public final void refresh() {
        this.checkLive();
        this.store.reset(this.builder);
        this.secureBuilder.baseChanged();
        this.modCount = 0L;
        if (this.permissionProvider.hasValue()) {
            ((PermissionProvider)this.permissionProvider.get()).refresh();
        }
    }

    public void commit(@NotNull Map<String, Object> info) throws CommitFailedException {
        this.checkLive();
        ContentSession session = this.getContentSession();
        CommitInfo commitInfo = new CommitInfo(session.toString(), session.getAuthInfo().getUserID(), MutableRoot.newInfoWithCommitContext(info));
        this.store.merge(this.builder, this.getCommitHook(), commitInfo);
        this.secureBuilder.baseChanged();
        this.modCount = 0L;
        if (this.permissionProvider.hasValue()) {
            ((PermissionProvider)this.permissionProvider.get()).refresh();
        }
        this.moveTracker.clear();
    }

    public void commit() throws CommitFailedException {
        this.commit(Collections.emptyMap());
    }

    private CommitHook getCommitHook() {
        ArrayList hooks = Lists.newArrayList();
        hooks.add(ResetCommitAttributeHook.INSTANCE);
        hooks.add(this.hook);
        ArrayList<CommitHook> postValidationHooks = new ArrayList<CommitHook>();
        ArrayList validators = new ArrayList();
        for (SecurityConfiguration sc : this.securityProvider.getConfigurations()) {
            for (CommitHook ch : sc.getCommitHooks(this.workspaceName)) {
                if (ch instanceof PostValidationHook) {
                    postValidationHooks.add(ch);
                    continue;
                }
                if (ch == EmptyHook.INSTANCE) continue;
                hooks.add(ch);
            }
            validators.addAll(sc.getValidators(this.workspaceName, this.subject.getPrincipals(), this.moveTracker));
        }
        if (!validators.isEmpty()) {
            hooks.add(new EditorHook(CompositeEditorProvider.compose(validators)));
        }
        hooks.addAll(postValidationHooks);
        return CompositeHook.compose((Collection)hooks);
    }

    public boolean hasPendingChanges() {
        this.checkLive();
        return this.modCount > 0L;
    }

    @NotNull
    public QueryEngine getQueryEngine() {
        this.checkLive();
        return new QueryEngineImpl(){

            @Override
            protected ExecutionContext getExecutionContext() {
                QueryIndexProvider provider = MutableRoot.this.indexProvider;
                if (MutableRoot.this.hasPendingChanges()) {
                    provider = new UUIDDiffIndexProviderWrapper(provider, MutableRoot.this.getBaseState(), MutableRoot.this.getRootState());
                }
                return new ExecutionContext(MutableRoot.this.getBaseState(), MutableRoot.this, MutableRoot.this.queryEngineSettings, provider, (PermissionProvider)MutableRoot.this.permissionProvider.get(), MutableRoot.this.store instanceof PrefetchNodeStore ? (PrefetchNodeStore)MutableRoot.this.store : PrefetchNodeStore.NOOP);
            }
        };
    }

    @NotNull
    public Blob createBlob(@NotNull InputStream inputStream) throws IOException {
        this.checkLive();
        return this.store.createBlob((InputStream)Preconditions.checkNotNull((Object)inputStream));
    }

    public Blob getBlob(@NotNull String reference) {
        return this.store.getBlob(reference);
    }

    @NotNull
    NodeState getBaseState() {
        return this.builder.getBaseState();
    }

    void updated() {
        ++this.modCount;
    }

    @NotNull
    private NodeState getRootState() {
        return this.builder.getNodeState();
    }

    @NotNull
    private AuthorizationConfiguration getAcConfig() {
        return (AuthorizationConfiguration)this.securityProvider.getConfiguration(AuthorizationConfiguration.class);
    }

    private static Map<String, Object> newInfoWithCommitContext(Map<String, Object> info) {
        return ImmutableMap.builder().putAll(info).put((Object)"oak.commitAttributes", (Object)new SimpleCommitContext()).build();
    }

    @NotNull
    public PermissionProvider getPermissionProvider() {
        return (PermissionProvider)this.permissionProvider.get();
    }

    class Move {
        private String source;
        private MutableTree destParent;
        private String destName;
        private Move next;

        Move() {
        }

        Move setMove(String source, MutableTree destParent, String destName) {
            this.source = source;
            this.destParent = destParent;
            this.destName = destName;
            this.next = new Move();
            return this.next;
        }

        Move apply(MutableTree tree) {
            Move move = this;
            while (move.next != null) {
                if (move.source.equals(tree.getPathInternal())) {
                    tree.setParentAndName(move.destParent, move.destName);
                }
                move = move.next;
            }
            return move;
        }

        public String toString() {
            return this.source == null ? "NIL" : ">" + this.source + ":" + PathUtils.concat((String)this.destParent.getPathInternal(), (String)this.destName);
        }
    }
}

