/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.UUID;
import org.apache.jackrabbit.guava.common.hash.Hasher;
import org.apache.jackrabbit.guava.common.hash.Hashing;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSegmentResponseEncoder
extends MessageToByteEncoder<GetSegmentResponse> {
    private static final Logger log = LoggerFactory.getLogger(GetSegmentResponseEncoder.class);
    private static final int EXTRA_HEADERS_LEN = 29;
    private static final int EXTRA_HEADERS_WO_SIZE = 25;

    protected void encode(ChannelHandlerContext ctx, GetSegmentResponse msg, ByteBuf out) throws Exception {
        log.debug("Sending segment {} to client {}", (Object)msg.getSegmentId(), (Object)msg.getClientId());
        GetSegmentResponseEncoder.encode(msg.getSegmentId(), msg.getSegmentData(), out);
    }

    private static void encode(String segmentId, byte[] data, ByteBuf out) {
        UUID id = UUID.fromString(segmentId);
        Hasher hasher = Hashing.murmur3_32().newHasher();
        long hash = hasher.putBytes(data).hash().padToLong();
        int len = data.length + 25;
        out.writeInt(len);
        out.writeByte(1);
        out.writeLong(id.getMostSignificantBits());
        out.writeLong(id.getLeastSignificantBits());
        out.writeLong(hash);
        out.writeBytes(data);
    }
}

