/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RDBRow {
    public static final long LONG_UNSET = Long.MIN_VALUE;
    private final String id;
    private final Long hasBinaryProperties;
    private final Boolean deletedOnce;
    private final long modified;
    private final long modcount;
    private final long cmodcount;
    private final long schemaVersion;
    private final long sdType;
    private final long sdMaxRevTime;
    private final String data;
    private final byte[] bdata;

    public RDBRow(String id, Long hasBinaryProperties, Boolean deletedOnce, Long modified, Long modcount, Long cmodcount, Long schemaVersion, Long sdType, Long sdMaxRevTime, String data, byte[] bdata) {
        this.id = id;
        this.hasBinaryProperties = hasBinaryProperties;
        this.deletedOnce = deletedOnce;
        this.modified = modified != null ? modified : Long.MIN_VALUE;
        this.modcount = modcount != null ? modcount : Long.MIN_VALUE;
        this.cmodcount = cmodcount != null ? cmodcount : Long.MIN_VALUE;
        this.schemaVersion = schemaVersion != null ? schemaVersion : Long.MIN_VALUE;
        this.sdType = sdType != null ? sdType : Long.MIN_VALUE;
        this.sdMaxRevTime = sdMaxRevTime != null ? sdMaxRevTime : Long.MIN_VALUE;
        this.data = data;
        this.bdata = bdata;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public Long hasBinaryProperties() {
        return this.hasBinaryProperties;
    }

    @Nullable
    public Boolean deletedOnce() {
        return this.deletedOnce;
    }

    @Nullable
    public String getData() {
        return this.data;
    }

    public long getModified() {
        return this.modified;
    }

    public long getModcount() {
        return this.modcount;
    }

    public long getCollisionsModcount() {
        return this.cmodcount;
    }

    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    public long getSdType() {
        return this.sdType;
    }

    public long getSdMaxRevTime() {
        return this.sdMaxRevTime;
    }

    @Nullable
    public byte[] getBdata() {
        return this.bdata;
    }
}

