/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.exceptions.mappers;

import edu.psu.swe.commons.jaxrs.ErrorMessage;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class WebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    private static final Logger log = LoggerFactory.getLogger(WebApplicationExceptionMapper.class);

    public Response toResponse(WebApplicationException e) {
        ErrorMessage em = new ErrorMessage(Response.Status.BAD_REQUEST);
        Response waeResponse = e.getResponse();
        Response.Status waeStatus = Response.Status.fromStatusCode((int)waeResponse.getStatus());
        em.setStatus(waeStatus);
        if (waeStatus.getFamily().equals((Object)Response.Status.Family.CLIENT_ERROR)) {
            em.addErrorMessage(e.getMessage());
            log.info(e.getMessage());
        } else if (waeStatus.getFamily().equals((Object)Response.Status.Family.SERVER_ERROR)) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return em.toResponse();
    }
}

