/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.quickinfo;

import java.io.Serializable;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

public class QuickInfoComponentSettings
implements Serializable {
    private String description;
    private boolean commentsEnabled = false;
    private boolean taxonomyEnabled = false;
    private boolean notificationAllowed = false;
    private boolean broadcastTicker = false;
    private boolean broadcastBlocking = false;
    private boolean delegatedNewsEnabled = false;
    private boolean mosaicViewForUsers = true;
    public static final String PARAM_COMMENTS = "comments";
    public static final String PARAM_TAXONOMY = "usePdc";
    public static final String PARAM_DELEGATED = "delegatedNews";
    public static final String PARAM_BROADCAST = "broadcasting";
    public static final String VALUE_BROADCAST_TICKER = "ticker";
    public static final String VALUE_BROADCAST_BLOCKING = "blocking";
    public static final String VALUE_BROADCAST_BOTH = "both";
    public static final String PARAM_USERVIEW = "userview";
    public static final String VALUE_USERVIEW_MOSAIC = "mosaic";
    public static final String VALUE_USERVIEW_LISTING = "listing";
    public static final String COMPONENT_NAME = "quickinfo";
    public static final String SETTINGS_PATH = "org.silverpeas.quickinfo.settings.quickInfoSettings";
    public static final String MESSAGES_PATH = "org.silverpeas.quickinfo.multilang.quickinfo";
    public static final String ICONS_PATH = "org.silverpeas.quickinfo.settings.quickinfoIcons";

    public QuickInfoComponentSettings(String desc) {
        this.description = desc;
    }

    public boolean isCommentsEnabled() {
        return this.commentsEnabled;
    }

    public void setCommentsEnabled(boolean commentsEnabled) {
        this.commentsEnabled = commentsEnabled;
    }

    public String getDescription() {
        return this.description;
    }

    public static LocalizationBundle getMessagesIn(String language) {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH, (String)language);
    }

    public static SettingBundle getSettings() {
        return ResourceLocator.getSettingBundle((String)SETTINGS_PATH);
    }

    public static LocalizationBundle getIcons() {
        return ResourceLocator.getLocalizationBundle((String)ICONS_PATH);
    }

    public void setTaxonomyEnabled(boolean taxonomyEnabled) {
        this.taxonomyEnabled = taxonomyEnabled;
    }

    public boolean isTaxonomyEnabled() {
        return this.taxonomyEnabled;
    }

    public void setNotificationAllowed(boolean notificationAllowed) {
        this.notificationAllowed = notificationAllowed;
    }

    public boolean isNotificationAllowed() {
        return this.notificationAllowed;
    }

    public void setBroadcastModes(String paramValue) {
        this.broadcastTicker = VALUE_BROADCAST_BOTH.equals(paramValue) || VALUE_BROADCAST_TICKER.equals(paramValue);
        this.broadcastBlocking = VALUE_BROADCAST_BOTH.equals(paramValue) || VALUE_BROADCAST_BLOCKING.equals(paramValue);
    }

    public boolean isBroadcastingByTicker() {
        return this.broadcastTicker;
    }

    public boolean isBroadcastingByBlockingNews() {
        return this.broadcastBlocking;
    }

    public void setDelegatedNewsEnabled(boolean delegatedNewsEnabled) {
        this.delegatedNewsEnabled = delegatedNewsEnabled;
    }

    public boolean isDelegatedNewsEnabled() {
        return this.delegatedNewsEnabled;
    }

    public boolean isMosaicViewForUsers() {
        return this.mosaicViewForUsers;
    }

    public void setMosaicViewForUsers(boolean mosaicView) {
        this.mosaicViewForUsers = mosaicView;
    }
}

