/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.webpages.notification;

import java.util.Collection;
import org.silverpeas.components.webpages.notification.AbstractWebPagesNotification;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.notification.user.UserSubscriptionNotificationBehavior;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.subscription.service.ResourceSubscriptionProvider;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberMapBySubscriberType;
import org.silverpeas.kernel.logging.SilverLogger;

public class WebPagesUserNotifier
extends AbstractWebPagesNotification
implements UserSubscriptionNotificationBehavior {
    private SubscriptionSubscriberMapBySubscriberType subscriberIdsByTypes;

    public static void notify(NodePK resource, String userId) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new WebPagesUserNotifier(resource, userId));
        }
        catch (Exception e) {
            SilverLogger.getLogger(WebPagesUserNotifier.class).warn((Throwable)e);
        }
    }

    public WebPagesUserNotifier(NodePK resource, String userId) {
        super(resource, User.getById((String)userId));
    }

    protected void initialize() {
        super.initialize();
        this.subscriberIdsByTypes = ResourceSubscriptionProvider.getSubscribersOfComponent((String)((NodePK)this.getResource()).getInstanceId()).indexBySubscriberType();
    }

    protected NotifAction getAction() {
        return NotifAction.UPDATE;
    }

    protected String getBundleSubjectKey() {
        return "webPages.subscription";
    }

    protected String getTemplateFileName() {
        return "notificationUpdateContent";
    }

    protected Collection<String> getUserIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.USER)).getAllIds();
    }

    protected Collection<String> getGroupIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.GROUP)).getAllIds();
    }
}

